package netwatcher.ssh2.info;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;

import netwatcher.ssh2.model.CommandFileParse;
import netwatcher.ssh2.preference.SSH2Preference;

public class TestSSHInfo {


	private static Logger logger;
	
	public void setSSHInfo(String userName, String host, String password, String passphrase) {
		
		logger = Logger.getLogger(this.getClass().getName());
		
		
		File keyFile = new File(SSH2Preference.RESOURCE_SSH2_DIR + userName + "@" + host + "/" + SSH2Preference.ID_RSA_FILE);
		
		CommandFileParse commandFile = new CommandFileParse();
		
		
		ArrayList commandList = null;
		try {
			commandList = commandFile
					.getCommandList(SSH2Preference.RESOURCE_SSH2_DIR + userName
							+ "@" + host + "/" + SSH2Preference.COMMAND_FILE);
		} catch (Exception e) {
			// TODO: handle exception
		}		
		if (keyFile == null) {
			logger.warning("resources/id_rsa null");
		} else {
			if (!keyFile.exists()) {
				logger.warning("resources/id_rsa no exists");
			}
			
			logger.info("Path : " + keyFile.getAbsolutePath());
		}
		
		
		
		

		
		
		
		
		Credentials cred = new Credentials();
		cred.setPassphrase(passphrase);
		cred.setIdRSAKeyFile(keyFile);
		
		
		SessionInfo sessionInfo = new SessionInfo();
		sessionInfo.setHost(host);
		sessionInfo.setPort(22);
		sessionInfo.setUserName(userName);
		
		NetWatcherUserInfo userInfo = new NetWatcherUserInfo(password, passphrase);

		
		SSHNodeInfo sshNodeInfo = new SSHNodeInfo();
		sshNodeInfo.setCredentials(cred);
		sshNodeInfo.setSshUserInfo(userInfo);
		sshNodeInfo.setSessionInfo(sessionInfo);
		sshNodeInfo.setCommandList(commandList);
		
		SSHNodeInfoControl.getInstance().setSSHInfo(userName + "@" + host, sshNodeInfo);
		
		
	}

}
