package netwatcher.ssh2.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netwatcher.ssh2.info.Credentials;
import netwatcher.ssh2.info.SSHNodeInfo;
import netwatcher.ssh2.info.SSHNodeInfoControl;
import netwatcher.ssh2.preference.SSH2Preference;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.internal.ccvs.core.util.Util;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;

public class SshTest {

	private static final int TIMEOUT = 10 * 1000;

	private static Map ourSessionsPool = new Hashtable();

	private static Logger logger;

	public SshTest() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public Session getSession(String ip) {
		/*
		 * if ("".equals(credentials.getUserName()) || credentials.getUserName() ==
		 * null) { throw new SVNAuthenticationException("User name is required
		 * to establish svn+shh connection"); }
		 */

		SSHNodeInfo sshNodeInfo = SSHNodeInfoControl.getInstance().getSSHInfo(
				ip);

		String userName = sshNodeInfo.getSessionInfo().getUserName();
		String host = sshNodeInfo.getSessionInfo().getHost();
		String password = sshNodeInfo.getSshUserInfo().getPassword();
		int port = sshNodeInfo.getSessionInfo().getPort();

		logger.info("userName : " + userName);
		logger.info("host : " + host);
		logger.info("password : " + password);
		logger.info("port : " + port);

		Credentials credentials = sshNodeInfo.getCredentials();

		String key = userName + ":" + host + ":" + port;
		Session session = (Session) ourSessionsPool.get(key);
		if (session != null && !session.isConnected()) {
			ourSessionsPool.remove(key);
			logger.info("SESSION " + key + " disposed");
			session = null;
		}
		try {
			if (session == null) {
				JSch jsch = JSchControl.getInstance().getJsch();

				test(jsch, credentials);

				session = jsch.getSession(userName, host, port);

				UserInfo userInfo = sshNodeInfo.getSshUserInfo();
				session.setUserInfo(userInfo);

				session.setSocketFactory(SimpleSocketFactory.getInstance());
				logger.info("SESSION " + key + " created");

				session.setTimeout(TIMEOUT);
				session.connect();
				session.setTimeout(0);
				ourSessionsPool.put(key, session);

				logger.info("SESSION " + key + " connected");

				ArrayList commandList = sshNodeInfo.getCommandList();
				execCommand(session, commandList);

				session.disconnect();

			} else {
				logger.info("SESSION " + key + " reused");
			}
			return session;
		} catch (JSchException e) {
			logger.warning(e.getMessage());
			if (session != null && session.isConnected()) {
				session.disconnect();
				logger.info("DISCONNECTING: " + session);
			}
			logger.info("SESSION " + key + " diconnected");
			ourSessionsPool.remove(key);
			logger.info("SESSION " + key + " disposed");
			// throw new SVNAuthenticationException(e);
		}

		return null;
	}

	private void execCommand(Session session, ArrayList commandList) throws JSchException {
		// exec command remotely
		
		
	

		for (int commandNo = 0; commandNo < commandList.size(); commandNo++) {
			ChannelExec channel = (ChannelExec) session.openChannel("exec");
			
			channel.setCommand((String)commandList.get(commandNo));
			channel.connect();
			System.out.println("command : " + commandNo + "  " + (String)commandList.get(commandNo));
			try {
				// get stdout
				InputStream in = channel.getInputStream();
				byte[] tmp = new byte[1024];
				while (true) {
					while (in.available() > 0) {
						int i = in.read(tmp, 0, 1024);
						if (i < 0)
							break;
						System.out.print(new String(tmp, 0, i));
					}
					if (channel.isClosed()) {
						System.out.println("exit-status: "
								+ channel.getExitStatus());
						break;
					}
					try {
						Thread.sleep(1000);
					} catch (Exception ee) {
						ee.printStackTrace();
					}
				}
			} catch (Exception e) {
				// TODO: handle exception
				logger.warning(e.getMessage());
				e.printStackTrace();
			}

			if (channel != null) {
				channel.disconnect();
			}
		}

	}

	private void test(JSch jsch, Credentials credentials) throws JSchException {

		String privateKey = null;
		String passphrase = null;
		if (credentials.getIdRSAKeyFile() != null) {
			privateKey = credentials.getIdRSAKeyFile().getAbsolutePath();
			passphrase = credentials.getPassphrase();

			logger.info("privateKey : " + privateKey);
			logger.info("passphrase : " + passphrase);

			if (privateKey != null && passphrase != null) {
				jsch.addIdentity(privateKey, passphrase);
			} else if (privateKey != null) {
				jsch.addIdentity(privateKey);
			}
		}

		/*
		 * File[] identities = new File[1]; if (identities != null) { for (int
		 * iterIdentities = 0; iterIdentities < identities.length;
		 * iterIdentities++) { final File privateKeyFile =
		 * identities[iterIdentities];
		 * 
		 * jsch.addIdentity(privateKeyFile.getAbsolutePath());
		 *  } } else { if (sshDir == null) { sshDir = findSshDir(); }
		 *  // Load the private key (rsa-key only) final File privateKeyFile =
		 * new File(sshDir, "id_rsa"); if (privateKeyFile.isFile() &&
		 * privateKeyFile.canRead()) { try {
		 * jsch.addIdentity(privateKeyFile.getAbsolutePath()); } catch (final
		 * JSchException e) {
		 *  } } }
		 */

	}




	
	public static void shutdown() {
		if (ourSessionsPool.size() > 0) {
			for (Iterator e = ourSessionsPool.values().iterator(); e.hasNext();) {
				Session session = (Session) (e.next());
				try {
					session.disconnect();
					// DebugLog.log("DISCONNECTING: " + session);
				} catch (Exception ee) {
				}
			}
			ourSessionsPool.clear();
		}
	}
}
