/*
 * Created on 2006/12/05
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.ssh2.plugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetJFWatcherRCPSSH2Plugin extends AbstractUIPlugin {

	//The shared instance.
	private static NetJFWatcherRCPSSH2Plugin plugin;
	
	/**
	 * The constructor.
	 */
	public NetJFWatcherRCPSSH2Plugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

    /**
     * UIPluginCX^XԂ܂B
     *
     * @return instance NetJFWatcherRCPSSH2Plugin
     */
    public static NetJFWatcherRCPSSH2Plugin getInstance() {
        return plugin;
    }
    
	/**
	 * Returns the shared instance.
	 */
	public static NetJFWatcherRCPSSH2Plugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("NetJFWatcherRCPSSH2", path);
	}
}
