/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.Session;

public class DiffListener
extends CommandOutputListener {
    PrintStream patchStream;
    boolean wroteToStream;
    static final String ERR_NOSUCHDIRECTORY = "cvs [diff aborted]: no such directory";

    public DiffListener(PrintStream patchStream) {
        this.patchStream = patchStream;
        this.wroteToStream = false;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (Session.IS_CRLF_PLATFORM && line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
            line = line.substring(0, line.length() - 1);
        }
        this.patchStream.println(line);
        this.wroteToStream = true;
        return OK;
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (this.getServerMessage(line, location) != null) {
            return OK;
        }
        if (line.indexOf(ERR_NOSUCHDIRECTORY) != -1) {
            return OK;
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    public boolean wroteToStream() {
        return this.wroteToStream;
    }
}

