/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap
extends HashMap {
    protected HashMap map = null;
    protected boolean fast = false;

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int n) {
        this.map = new HashMap(n);
    }

    public FastHashMap(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public FastHashMap(Map map) {
        this.map = new HashMap(map);
    }

    public void clear() {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.clear();
                this.map = hashMap;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    public Object clone() {
        FastHashMap fastHashMap = null;
        if (this.fast) {
            fastHashMap = new FastHashMap((Map)this.map);
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                fastHashMap = new FastHashMap((Map)this.map);
            }
        }
        fastHashMap.setFast(this.getFast());
        return fastHashMap;
    }

    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.containsKey(object);
            Object var4_4 = null;
            return bl;
        }
    }

    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.containsValue(object);
            Object var4_4 = null;
            return bl;
        }
    }

    public Set entrySet() {
        return new EntrySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) != null) return false;
                    if (map.containsKey(k)) continue;
                    return false;
                }
                if (v.equals(map.get(k))) continue;
                return false;
            }
            return true;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) != null) return false;
                    if (map.containsKey(k)) continue;
                    return false;
                }
                if (v.equals(map.get(k))) continue;
                return false;
            }
            return true;
        }
    }

    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object v = this.map.get(object);
            Object var4_4 = null;
            return v;
        }
    }

    public boolean getFast() {
        return this.fast;
    }

    public int hashCode() {
        if (this.fast) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            int n2 = n;
            Object var3_7 = null;
            return n2;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.isEmpty();
            Object var3_3 = null;
            return bl;
        }
    }

    public Set keySet() {
        return new KeySet();
    }

    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object object3 = hashMap.put(object, object2);
                this.map = hashMap;
                Object object4 = object3;
                Object var5_9 = null;
                return object4;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object object5 = this.map.put(object, object2);
            Object var5_10 = null;
            return object5;
        }
    }

    public void putAll(Map map) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.putAll(map);
                this.map = hashMap;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.putAll(map);
        }
    }

    public Object remove(Object object) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object v = hashMap.remove(object);
                this.map = hashMap;
                Object v2 = v;
                Object var4_8 = null;
                return v2;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object v = this.map.remove(object);
            Object var4_9 = null;
            return v;
        }
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n = this.map.size();
            Object var3_3 = null;
            return n;
        }
    }

    public Collection values() {
        return new Values();
    }

    private abstract class CollectionView
    implements Collection {
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)FastHashMap.this.map.clone();
                    this.get(hashMap).clear();
                    FastHashMap.this.map = hashMap;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                this.get(FastHashMap.this.map).clear();
            }
        }

        public boolean contains(Object object) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).contains(object);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).contains(object);
                Object var4_4 = null;
                return bl;
            }
        }

        public boolean containsAll(Collection collection) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).containsAll(collection);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).containsAll(collection);
                Object var4_4 = null;
                return bl;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).equals(object);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).equals(object);
                Object var4_4 = null;
                return bl;
            }
        }

        protected abstract Collection get(Map var1);

        public int hashCode() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).hashCode();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                int n = this.get(FastHashMap.this.map).hashCode();
                Object var3_3 = null;
                return n;
            }
        }

        public boolean isEmpty() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).isEmpty();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).isEmpty();
                Object var3_3 = null;
                return bl;
            }
        }

        public Iterator iterator() {
            return new CollectionViewIterator();
        }

        protected abstract Object iteratorNext(Map.Entry var1);

        public boolean remove(Object object) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)FastHashMap.this.map.clone();
                    boolean bl = this.get(hashMap).remove(object);
                    FastHashMap.this.map = hashMap;
                    boolean bl2 = bl;
                    Object var4_8 = null;
                    return bl2;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).remove(object);
                Object var4_9 = null;
                return bl;
            }
        }

        public boolean removeAll(Collection collection) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)FastHashMap.this.map.clone();
                    boolean bl = this.get(hashMap).removeAll(collection);
                    FastHashMap.this.map = hashMap;
                    boolean bl2 = bl;
                    Object var4_8 = null;
                    return bl2;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).removeAll(collection);
                Object var4_9 = null;
                return bl;
            }
        }

        public boolean retainAll(Collection collection) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap hashMap = (HashMap)FastHashMap.this.map.clone();
                    boolean bl = this.get(hashMap).retainAll(collection);
                    FastHashMap.this.map = hashMap;
                    boolean bl2 = bl;
                    Object var4_8 = null;
                    return bl2;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).retainAll(collection);
                Object var4_9 = null;
                return bl;
            }
        }

        public int size() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).size();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                int n = this.get(FastHashMap.this.map).size();
                Object var3_3 = null;
                return n;
            }
        }

        public Object[] toArray() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).toArray();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                Object[] objectArray = this.get(FastHashMap.this.map).toArray();
                Object var3_3 = null;
                return objectArray;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).toArray(objectArray);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                Object[] objectArray2 = this.get(FastHashMap.this.map).toArray(objectArray);
                Object var4_4 = null;
                return objectArray2;
            }
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned = null;
            private Iterator iterator;

            public CollectionViewIterator() {
                this.expected = ((CollectionView)CollectionView.this).FastHashMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != ((CollectionView)CollectionView.this).FastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != ((CollectionView)CollectionView.this).FastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (((CollectionView)CollectionView.this).FastHashMap.this.fast) {
                    FastHashMap fastHashMap = FastHashMap.this;
                    synchronized (fastHashMap) {
                        if (this.expected != ((CollectionView)CollectionView.this).FastHashMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        FastHashMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = ((CollectionView)CollectionView.this).FastHashMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        EntrySet() {
        }

        protected Collection get(Map map) {
            return map.entrySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        KeySet() {
        }

        protected Collection get(Map map) {
            return map.keySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }
    }

    private class Values
    extends CollectionView {
        Values() {
        }

        protected Collection get(Map map) {
            return map.values();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }
    }
}

