/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.localstore.IUnifiedTreeVisitor;
import org.eclipse.core.internal.localstore.UnifiedTreeNode;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class DeleteVisitor
implements IUnifiedTreeVisitor,
ICoreConstants {
    protected IProgressMonitor monitor;
    protected boolean force;
    protected boolean keepHistory;
    protected MultiStatus status;
    protected List skipList;
    private int ticks;

    public DeleteVisitor(List skipList, int flags, IProgressMonitor monitor, int ticks) {
        this.skipList = skipList;
        this.ticks = ticks;
        this.force = (flags & 1) != 0;
        this.keepHistory = (flags & 2) != 0;
        this.monitor = monitor;
        this.status = new MultiStatus("org.eclipse.core.resources", 273, Messages.localstore_deleteProblem, null);
        if (this.keepHistory) {
            ticks *= 2;
        }
    }

    protected void delete(UnifiedTreeNode node, boolean deleteLocalFile, boolean shouldKeepHistory) {
        Resource target = (Resource)node.getResource();
        try {
            IFileStore localFile;
            deleteLocalFile = deleteLocalFile && !target.isLinked() && node.existsInFileSystem();
            IFileStore iFileStore = localFile = deleteLocalFile ? node.getStore() : null;
            if (shouldKeepHistory) {
                IHistoryStore store = target.getLocalManager().getHistoryStore();
                this.recursiveKeepHistory(store, node);
            }
            node.removeChildrenFromTree();
            int work = this.ticks < 0 ? 0 : this.ticks;
            this.ticks -= work;
            if (localFile != null && !target.isLinked()) {
                localFile.delete(0, Policy.subMonitorFor(this.monitor, work));
            } else {
                this.monitor.worked(work);
            }
            if (target != null && node.existsInWorkspace()) {
                target.deleteResource(true, this.status);
            }
        }
        catch (CoreException e) {
            this.status.add(e.getStatus());
            try {
                target.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void recursiveKeepHistory(IHistoryStore store, UnifiedTreeNode node) {
        if (node.isFolder()) {
            this.monitor.subTask(NLS.bind((String)Messages.localstore_deleting, (Object)node.getResource().getFullPath()));
            Iterator children = node.getChildren();
            while (children.hasNext()) {
                this.recursiveKeepHistory(store, (UnifiedTreeNode)children.next());
            }
        } else {
            IFileInfo info = node.fileInfo;
            if (info == null) {
                info = new FileInfo(node.getLocalName());
            }
            store.addState(node.getResource().getFullPath(), node.getStore(), info, true);
        }
        this.monitor.worked(1);
    }

    protected boolean equals(IResource one, IResource another) {
        return one.getFullPath().equals((Object)another.getFullPath());
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    protected boolean isAncestor(IResource one, IResource another) {
        return one.getFullPath().isPrefixOf(another.getFullPath()) && !this.equals(one, another);
    }

    protected boolean isAncestorOfResourceToSkip(IResource resource) {
        if (this.skipList == null) {
            return false;
        }
        int i = 0;
        while (i < this.skipList.size()) {
            IResource target = (IResource)this.skipList.get(i);
            if (this.isAncestor(resource, target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeFromSkipList(IResource resource) {
        if (this.skipList != null) {
            this.skipList.remove(resource);
        }
    }

    protected boolean shouldSkip(IResource resource) {
        if (this.skipList == null) {
            return false;
        }
        int i = 0;
        while (i < this.skipList.size()) {
            if (this.equals(resource, (IResource)this.skipList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean visit(UnifiedTreeNode node) {
        Policy.checkCanceled(this.monitor);
        Resource target = (Resource)node.getResource();
        if (target.getType() == 4) {
            return true;
        }
        if (this.shouldSkip(target)) {
            this.removeFromSkipList(target);
            int skipTicks = target.countResources(2, false);
            this.monitor.worked(skipTicks);
            this.ticks -= skipTicks;
            return false;
        }
        if (this.isAncestorOfResourceToSkip(target)) {
            return true;
        }
        this.delete(node, true, this.keepHistory);
        return false;
    }
}

