/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model.hsqldb;

import java.util.ArrayList;
import netjfwatcher.engine.resource.DatabasePropertyResource;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;

public final class HsqldbParams {
    private String driver = "org.hsqldb.jdbcDriver";
    private String accessUrl = "jdbc:hsqldb:hsql://127.0.0.1:9001";
    private String port = "9001";
    private String user = "sa";
    private String passwd = "";

    private HsqldbParams() {
        this.setHSQLDBParam();
    }

    private void setHSQLDBParam() {
        ArrayList databasePropList = DatabasePropertyResource.getInstance().getdatabasePropList().getDatabasePropList();
        int i = 0;
        while (i < databasePropList.size()) {
            DatabasePropertyInfo info = (DatabasePropertyInfo)databasePropList.get(i);
            if (info.getDatabaseName().equals("HSQLDB")) {
                String url = info.getDatabaseUrl();
                String[] spilUrl = url.split(":");
                String workPort = "9001";
                if (spilUrl.length > 0) {
                    String work = spilUrl[spilUrl.length - 1];
                    int pos = work.indexOf("/");
                    workPort = pos > 0 ? work.substring(0, pos) : work;
                }
                this.driver = info.getDatabaseDriver();
                this.accessUrl = info.getDatabaseUrl();
                this.port = workPort;
                this.user = info.getDatabaseUser();
                this.passwd = info.getDatabasePassword();
            }
            ++i;
        }
    }

    public static HsqldbParams getInstance() {
        return SingletonResource.HSQLDB_PARAM;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    /* synthetic */ HsqldbParams(HsqldbParams hsqldbParams) {
        this();
    }

    private static class SingletonResource {
        static final HsqldbParams HSQLDB_PARAM = new HsqldbParams(null);

        private SingletonResource() {
        }
    }
}

