/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm;

import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;
import netjfwatcher.engine.alarm.SearchNoderegisterInfo;
import netjfwatcher.engine.mail.MailSendInfoList;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.xmlsocket.XMLSocketConnectPushQueue;
import netjfwatcher.engine.socket.info.ResourceInfo;

public final class AlarmPut {
    public static final String APL_ERROR_MESSAGE = "Application";
    public static final String HONEY_PORT_SCAN_NODE_MESSAGE = "Port Scan";
    private static Logger logger = null;
    private boolean isNodeDiscovery = false;
    private final SearchNoderegisterInfo nodeSearchInstance = new SearchNoderegisterInfo();
    private final DateFormat dateformat = DateFormat.getDateTimeInstance();

    private AlarmPut() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static AlarmPut getInstance() {
        return SingletonAlarmPut.ALARMPUT;
    }

    public synchronized boolean putAlarm(String ipaddress, AlarmCodeInformation alarminfo, String message) {
        String group;
        String nodename;
        if (!DatabaseControl.getInstance().isDatabaseStart()) {
            logger.warning("Abort put Alarm for Not running Database.");
            return false;
        }
        if (this.isNodeDiscovery) {
            return false;
        }
        if (!ipaddress.equals(APL_ERROR_MESSAGE) && !ipaddress.equals(HONEY_PORT_SCAN_NODE_MESSAGE)) {
            ArrayList alarmList = this.nodeSearchInstance.searchInfo("ipaddress", ipaddress);
            if (alarmList != null && alarmList.size() != 0) {
                nodename = ((NodeWatchInfo)alarmList.get(0)).getNodename();
                group = ((NodeWatchInfo)alarmList.get(0)).getGroup();
            } else {
                nodename = "unknown";
                group = "unknown";
                ResourceInfo resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
                if (resourceInfo.getUnregistrationNodeAlarm().equals("ignore")) {
                    logger.info("Ignore Alarm Unregistration Node Alarm IP=" + ipaddress + " " + message);
                    return false;
                }
            }
        } else {
            nodename = ipaddress;
            group = "unknown";
        }
        DBTableAlarm alarmTable = DBTableAlarm.getInstance();
        try {
            try {
                alarmTable.putAlarm(ipaddress, nodename, group, alarminfo, message);
            }
            catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            alarmTable = null;
        }
        alarminfo.setIpaddress(ipaddress);
        alarminfo.setNodename(nodename);
        alarminfo.setGroup(group);
        AlarmMessageQueue.getInstance().pushAlarmData(alarminfo);
        MailSendInfoList.getInstance().setMailList(ipaddress, message, alarminfo.getLevel(), alarminfo.getCode());
        Date date = Calendar.getInstance().getTime();
        XMLSocketConnectPushQueue pushqueue = XMLSocketConnectPushQueue.getInstance();
        pushqueue.addEventToXMLSocketInfoList(String.valueOf(ipaddress) + ": " + this.dateformat.format(date) + ": " + message);
        return true;
    }

    public boolean isNodeDiscovery() {
        return this.isNodeDiscovery;
    }

    public void setNodeDiscovery(boolean isNodeDiscovery) {
        this.isNodeDiscovery = isNodeDiscovery;
    }

    /* synthetic */ AlarmPut(AlarmPut alarmPut) {
        this();
    }

    private static class SingletonAlarmPut {
        static final AlarmPut ALARMPUT = new AlarmPut(null);

        private SingletonAlarmPut() {
        }
    }
}

