/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.engine.command.control.CommnadReceiveServer;
import netjfwatcher.engine.mail.ThreadMailSendGuard;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.model.action.DatabaseLoad;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.engine.model.thread.ManageEngineThread;
import netjfwatcher.engine.model.thread.TrapReceiveThread;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.QueueForDatabseWatch;
import netjfwatcher.engine.server.protocol.control.QueueForDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.QueueForHTTP;
import netjfwatcher.engine.server.protocol.control.QueueForPing;
import netjfwatcher.engine.server.protocol.control.QueueForPop3;
import netjfwatcher.engine.server.protocol.control.QueueForSmtp;
import netjfwatcher.engine.server.protocol.control.QueueForStatisticsMib;
import netjfwatcher.engine.server.xmlsocket.XMLSocketServer;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.snmpmanager.trap.TrapListenerImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderEngine {
    private static Logger logger;
    private IAction startEngine = new ActionStartEngine();
    private IAction stopEngine = new ActionStopEngine();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderEngine() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionStartEngine() {
        return this.startEngine;
    }

    public IAction getActionStopEngine() {
        return this.stopEngine;
    }

    private abstract class AbstractEngineAction
    extends Action {
        private AbstractEngineAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionStartEngine
    extends AbstractEngineAction {
        private ActionStartEngine() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderEngine.this.bundle.getEntry("icons/engine.gif"));
        }

        public String getText() {
            return "Engine start";
        }

        public String getToolTipText() {
            return "Engine\u3092\u958b\u59cb\u3057\u307e\u3059";
        }

        protected void doTask() {
            this.startEngine();
        }

        private void startEngine() {
            final Shell shell = new Shell();
            if (EngineStatus.getInstance().isEngine()) {
                MessageDialog.openError((Shell)shell, (String)"Already Start Engine", (String)"Already Start Engine.");
                if (shell != null) {
                    shell.dispose();
                }
                return;
            }
            if (NetJFWatcherApplication.getGenericResourceView() != null && NetJFWatcherApplication.getGenericResourceView().getViewSite().getPage().isEditorAreaVisible()) {
                NetJFWatcherApplication.getGenericResourceView().setDisableAllButton();
            }
            this.startDatabase(shell);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ActionStartEngine.this.startEngine(shell);
                }
            });
            if (shell != null) {
                shell.dispose();
            }
        }

        private void startEngine(Shell shell) {
            EngineStatus.getInstance().setEngine(true);
            try {
                ManageEngineThread engineThread = new ManageEngineThread();
                engineThread.startThread();
            }
            catch (DatabaseConnectionException e1) {
                logger.warning("Abort Engine start " + e1.getMessage());
                MessageDialog.openError((Shell)shell, (String)"Abort Engine start", (String)("Abort Engine start by DatabaseConnectionException " + e1.getMessage()));
                e1.printStackTrace();
            }
            catch (SQLException e1) {
                MessageDialog.openError((Shell)shell, (String)"Abort Engine start", (String)("Abort Engine start by SQLException " + e1.getMessage()));
                e1.printStackTrace();
            }
            QueueForPing.getInstance().setPause(false);
            QueueForDefaultSnmpMib.getInstance().setPause(false);
            QueueForStatisticsMib.getInstance().setPause(false);
            QueueForHTTP.getInstance().setPause(false);
            QueueForSmtp.getInstance().setPause(false);
            QueueForPop3.getInstance().setPause(false);
            QueueForDatabseWatch.getInstance().setPause(false);
            try {
                try {
                    TrapListenerImpl listener = TrapListenerImpl.getInstance();
                    TrapReceiveThread trapthread = TrapReceiveThread.getInstance();
                    trapthread.startReceiving();
                    trapthread.addTrapListener(listener);
                    EngineThreadList.getInstance().setThreadList("Trap receive", trapthread.getTrapReceiveThread());
                    if (!TrapReceiveThread.getInstance().checkThread()) {
                        MessageDialog.openError((Shell)shell, (String)"Abort start Trap manager", (String)"Abort start Trap manager.");
                    }
                }
                catch (Exception e) {
                    logger.warning("Abort Trap start. : " + e.getMessage());
                    MessageDialog.openError((Shell)shell, (String)"Trap thread error", (String)("Abort start Trap manager. : " + e.getMessage()));
                    e.printStackTrace();
                }
            }
            finally {
                if (NetJFWatcherApplication.getGenericResourceView() != null && NetJFWatcherApplication.getGenericResourceView().getViewSite().getPage().isEditorAreaVisible()) {
                    NetJFWatcherApplication.getGenericResourceView().refreshView(true);
                }
            }
        }

        private void startDatabase(Shell shell) {
            if (MessageDialog.openQuestion((Shell)shell, (String)"Confirm", (String)"Initialize Database ?")) {
                DatabaseControl.getInstance().startDatabase(true);
            } else {
                DatabaseControl.getInstance().startDatabase(false);
                DatabaseLoad.getInstance().loadDatabase();
            }
        }
    }

    private final class ActionStopEngine
    extends AbstractEngineAction {
        private ActionStopEngine() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderEngine.this.bundle.getEntry("icons/engine_stop.gif"));
        }

        public String getText() {
            return "Engine stop";
        }

        public String getToolTipText() {
            return "Engine\u3092\u505c\u6b62\u3057\u307e\u3059";
        }

        protected void doTask() {
            EngineStatus.getInstance().setEngine(false);
            Shell shell = new Shell();
            NetJFWatcherApplication.getGenericResourceView().setDisableAllButton();
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    EngineThreadList.getInstance().removeThreadList("Trap receive");
                    TrapReceiveThread trapthread = TrapReceiveThread.getInstance();
                    trapthread.stopReceiving();
                    CommnadReceiveServer.getInstance().stopReceiving();
                    EngineThreadList.getInstance().removeThreadList("Command receive");
                    XMLSocketServer.getInstance().stopXMLSocketServerReceiving();
                    EngineThreadList.getInstance().removeThreadList("XML Socket");
                    ThreadMailSendGuard.getInstance().stopReceiving();
                    EngineThreadList.getInstance().removeThreadList("Mail guard");
                    ThreadPeriodHoldCheck.getInstance().stopReceiving();
                    EngineThreadList.getInstance().removeThreadList("Database limit check");
                    ActionStopEngine.this.stopDatabase();
                    NetJFWatcherApplication.getGenericResourceView().refreshView(true);
                    QueueForPing.getInstance().setPause(true);
                    QueueForDefaultSnmpMib.getInstance().setPause(true);
                    QueueForStatisticsMib.getInstance().setPause(true);
                    QueueForHTTP.getInstance().setPause(true);
                    QueueForSmtp.getInstance().setPause(true);
                    QueueForPop3.getInstance().setPause(true);
                    QueueForDatabseWatch.getInstance().setPause(true);
                }
            });
            if (shell != null) {
                shell.dispose();
            }
        }

        private void stopDatabase() {
            ResourceInfo info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
            String databaseKind = info.getDatabaseName();
            if (databaseKind.equals("HSQLDB")) {
                try {
                    HsqldbControl.getInstance().stopHsqlDB();
                }
                catch (ClassNotFoundException e3) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e3.getMessage());
                    shell.dispose();
                }
                catch (SQLException e3) {
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e3.getMessage());
                    shell.dispose();
                }
            } else if (databaseKind.equals("Apache Derby")) {
                try {
                    ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
            } else if (databaseKind.equals("Embedded Derby")) {
                try {
                    ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)e.getMessage());
                    shell.dispose();
                }
            }
        }
    }
}

