/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.ping.EditorNodePingResponseData;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsData;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderNodeDataTable {
    private static Logger logger;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IEditorPart editorNodeConfigView;
    private IAction showPingData = new ActionShowPingResponseData();
    private IAction showPingDataSocket = new ActionShowPingResponseDataSocket();

    public ActionBuilderNodeDataTable() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction actionShowPingDataView() {
        return this.showPingData;
    }

    public IAction actionShowPingDataViewSocket() {
        return this.showPingDataSocket;
    }

    public IAction actionShowStatisticsData() {
        return new ActionShowStatisticsData();
    }

    public IAction actionShowStatisticsDataSocket() {
        return new ActionShowStatisticsDataSocket();
    }

    protected abstract class AbstractDataTableAction
    extends Action {
        protected AbstractDataTableAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public final class ActionShowStatisticsData
    extends AbstractDataTableAction {
        private NodeInformation nodeInfo;
        private String oid;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataTable.this.bundle.getEntry("icons/table.gif"));
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataTable.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataTable.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataTable.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataTable.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp Statistics Data View" + " OID=" + this.oid, this.nodeInfo, false, this.oid), EditorNodeSnmpStatisticsData.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionShowStatisticsDataSocket
    extends AbstractDataTableAction {
        private NodeInformation nodeInfo;
        private String oid;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataTable.this.bundle.getEntry("icons/table.gif"));
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataTable.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataTable.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataTable.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataTable.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp Statistics Data View" + " OID=" + this.oid + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true, this.oid), EditorNodeSnmpStatisticsData.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionShowPingResponseData
    extends AbstractDataTableAction {
        private NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataTable.this.bundle.getEntry("icons/table.gif"));
        }

        public String getText() {
            return "Ping response";
        }

        public String getToolTipText() {
            return "Ping response";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataTable.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataTable.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataTable.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataTable.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Ping Data View", this.nodeInfo, false), EditorNodePingResponseData.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionShowPingResponseDataSocket
    extends AbstractDataTableAction {
        private NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeDataTable.this.bundle.getEntry("icons/table.gif"));
        }

        public String getText() {
            return "Ping response";
        }

        public String getToolTipText() {
            return "Ping response";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                if (ActionBuilderNodeDataTable.this.editorNodeConfigView != null) {
                    activePage.closeEditor(ActionBuilderNodeDataTable.this.editorNodeConfigView, false);
                    ActionBuilderNodeDataTable.this.editorNodeConfigView = null;
                }
                ActionBuilderNodeDataTable.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Ping Data View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true), EditorNodePingResponseData.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }
}

