/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public final class MediaResource {
    private static Logger logger = null;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private HashMap<String, String> iconDataList = new HashMap();
    private ArrayList<String> soundFileList = new ArrayList();

    private MediaResource() {
        logger = Logger.getLogger(this.getClass().getName());
        Document doc = this.getDocument();
        try {
            Element root = doc.getRootElement();
            List soundList = root.getChildren("Sound");
            List iconList = root.getChildren("Icon");
            for (Element soundFileEl : soundList) {
                this.soundFileList.add(soundFileEl.getChild("sound_file").getAttributeValue("value"));
            }
            for (Element iconLabelEl : iconList) {
                this.iconDataList.put(iconLabelEl.getChild("Icon_Label").getAttributeValue("value"), iconLabelEl.getChild("Icon_Data").getAttributeValue("value"));
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private Document getDocument() {
        Document doc = null;
        try {
            URL url = this.bundle.getEntry("resources/Flash_resource.xml");
            if (url == null) {
                logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
                return doc;
            }
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public HashMap getIconDataList() {
        return this.iconDataList;
    }

    public String getNodeIconFullFileName(String nodeKind) {
        return this.iconDataList.get(nodeKind);
    }

    public String getNodeIcon16FileName(String nodeKind) {
        String nodeIconFullKindFile = this.iconDataList.get(nodeKind);
        int nodeNamePosition = nodeIconFullKindFile.indexOf("/");
        String nodeKindName = nodeIconFullKindFile.substring(nodeNamePosition);
        String node16IconFileName = "icon/node16" + nodeKindName;
        return node16IconFileName;
    }

    public ArrayList getSoundFileList() {
        return this.soundFileList;
    }

    public static MediaResource getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ MediaResource(MediaResource mediaResource) {
        this();
    }

    private static class SingletonResource {
        static final MediaResource RESOURCE = new MediaResource(null);

        private SingletonResource() {
        }
    }
}

