/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.thread;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.command.control.CommnadReceiveServer;
import netjfwatcher.engine.mail.ThreadMailSendGuard;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.engine.server.holdperiod.ThreadPeriodHoldCheck;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushDefaultSnmpMib;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushHTTPControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushPingControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushPop3Control;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushSmtpControl;
import netjfwatcher.engine.server.protocol.control.ThreadListReadQueuePushStatisticMibControl;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckDatabaseWatch;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckDefaultSnmpMibGet;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckHTTP;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckPing;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckPop3;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckSmtp;
import netjfwatcher.engine.server.protocol.control.ThreadQueueCheckStatisticsMibGet;
import netjfwatcher.engine.server.xmlsocket.XMLSocketServer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ManageEngineThread
implements Runnable {
    public static final int PING_CHECK_THREAD_NO = 10;
    public static final int DEFAULT_SNMP_THREAD_NO = 10;
    public static final int STATISTICS_MIB_THREAD_NO = 10;
    public static final int HTTP_CHECK_THREAD_NO = 10;
    public static final int POP3_CHECK_THREAD_NO = 10;
    public static final int SMTP_CHECK_THREAD_NO = 10;
    public static final int DATABASE_CHECK_THREAD_NO = 10;
    private static Logger logger;

    public ManageEngineThread() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void startThread() throws DatabaseConnectionException, SQLException {
        Shell shell;
        try {
            CommnadReceiveServer.getInstance().startThread();
            EngineThreadList.getInstance().setThreadList("Command receive", CommnadReceiveServer.getInstance().getCommandReceiveThread());
        }
        catch (IOException e) {
            logger.warning("Command receive thread error. " + e.getMessage());
            shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Command receive thread error", (String)("Command receive thread error, " + e.getMessage()));
            shell.dispose();
            e.printStackTrace();
        }
        try {
            XMLSocketServer xmlsocketserver = XMLSocketServer.getInstance();
            xmlsocketserver.startXMLSocketServerThread();
            EngineThreadList.getInstance().setThreadList("XML Socket", xmlsocketserver.getXmlSocketServerThread());
        }
        catch (IOException e) {
            logger.warning("XML Socket thread error. " + e.getMessage());
            shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"XML Socket receive thread error", (String)("XML Socket receive thread error, " + e.getMessage()));
            shell.dispose();
            e.printStackTrace();
        }
        ManageEngineThread engineThread = new ManageEngineThread();
        Thread thread = new Thread(engineThread);
        thread.start();
    }

    public void run() {
        int i = 0;
        while (i < 10) {
            Thread pingThread = new Thread(new ThreadQueueCheckPing());
            pingThread.start();
            EngineThreadList.getInstance().setThreadList("Ping check exec" + i, pingThread);
            ++i;
        }
        int i2 = 0;
        while (i2 < 10) {
            Thread statisticsMibGetThread = new Thread(new ThreadQueueCheckStatisticsMibGet());
            statisticsMibGetThread.start();
            EngineThreadList.getInstance().setThreadList("Snmp statistics" + i2, statisticsMibGetThread);
            ++i2;
        }
        int i3 = 0;
        while (i3 < 10) {
            Thread defaultSnmpMibGetThread = new Thread(new ThreadQueueCheckDefaultSnmpMibGet());
            defaultSnmpMibGetThread.start();
            EngineThreadList.getInstance().setThreadList("Snmp config" + i3, defaultSnmpMibGetThread);
            ++i3;
        }
        Thread pingListCheck = new Thread(new ThreadListReadQueuePushPingControl());
        pingListCheck.start();
        EngineThreadList.getInstance().setThreadList("Ping check queue", pingListCheck);
        Thread statisticsMibListCheck = new Thread(new ThreadListReadQueuePushStatisticMibControl());
        statisticsMibListCheck.start();
        EngineThreadList.getInstance().setThreadList("Snmp statistics queue", statisticsMibListCheck);
        Thread defaultSnmpMibListCheck = new Thread(new ThreadListReadQueuePushDefaultSnmpMib());
        defaultSnmpMibListCheck.start();
        EngineThreadList.getInstance().setThreadList("Snmp config queue", defaultSnmpMibListCheck);
        ThreadMailSendGuard.getInstance().startThread();
        EngineThreadList.getInstance().setThreadList("Mail guard", ThreadMailSendGuard.getInstance().getMailGuardThread());
        ThreadPeriodHoldCheck.getInstance().startThread();
        EngineThreadList.getInstance().setThreadList("Database limit check", ThreadPeriodHoldCheck.getInstance().getPeriodHoldCheckThread());
        int i4 = 0;
        while (i4 < 10) {
            Thread httpThread = new Thread(new ThreadQueueCheckHTTP());
            httpThread.start();
            EngineThreadList.getInstance().setThreadList("Http check exec" + i4, httpThread);
            ++i4;
        }
        Thread httpListCheck = new Thread(new ThreadListReadQueuePushHTTPControl());
        httpListCheck.start();
        EngineThreadList.getInstance().setThreadList("Http check exec queue", httpListCheck);
        int i5 = 0;
        while (i5 < 10) {
            Thread pop3Thread = new Thread(new ThreadQueueCheckPop3());
            pop3Thread.start();
            EngineThreadList.getInstance().setThreadList("Pop3 check exec" + i5, pop3Thread);
            ++i5;
        }
        Thread pop3ListCheck = new Thread(new ThreadListReadQueuePushPop3Control());
        pop3ListCheck.start();
        EngineThreadList.getInstance().setThreadList("Pop3 check exec queue", pop3ListCheck);
        int i6 = 0;
        while (i6 < 10) {
            Thread smtpThread = new Thread(new ThreadQueueCheckSmtp());
            smtpThread.start();
            EngineThreadList.getInstance().setThreadList("Smtp check exec" + i6, smtpThread);
            ++i6;
        }
        Thread smtpListCheck = new Thread(new ThreadListReadQueuePushSmtpControl());
        smtpListCheck.start();
        EngineThreadList.getInstance().setThreadList("Smtp check exec queue", smtpListCheck);
        int i7 = 0;
        while (i7 < 10) {
            Thread databaseThread = new Thread(new ThreadQueueCheckDatabaseWatch());
            databaseThread.start();
            EngineThreadList.getInstance().setThreadList("Database check exec" + i7, databaseThread);
            ++i7;
        }
        Thread databaseListCheck = new Thread(new ThreadListReadQueuePushDatabaseWatchControl());
        databaseListCheck.start();
        EngineThreadList.getInstance().setThreadList("Database check exec queue", databaseListCheck);
    }
}

