/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.noderegister.snmp;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import netjfwatcher.engine.server.protocol.snmp.SnmpInterfacesMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpPrintMibGet;
import netjfwatcher.engine.server.protocol.snmp.SnmpSystemMibGet;
import netjfwatcher.engine.snmpmanager.statistics.StatisticsMibDBRegister;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class NodeSnmpRegisterInitializeThread
implements Runnable {
    private static Logger logger;
    private String targetip;
    private int version;
    private int period;
    private String community;
    private int snmpLevel;
    private String nodeKind;

    public NodeSnmpRegisterInitializeThread(String targetip, int version, int period, String community, int snmpLevel, String nodeKind) {
        this.targetip = targetip;
        this.version = version;
        this.period = period;
        this.snmpLevel = snmpLevel;
        this.community = community;
        this.nodeKind = nodeKind;
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        try {
            StatisticsMibDBRegister mibStatisGet;
            SnmpSystemMibGet systemMib = new SnmpSystemMibGet();
            systemMib.setSnmpSystemMibGet(this.targetip, this.version, this.community);
            systemMib.getInitialyzeSystemMIB();
            logger.info("SNMP System Mib Get " + this.targetip);
            SnmpInterfacesMibGet mibInterfacesGet = new SnmpInterfacesMibGet();
            mibInterfacesGet.setSnmpInterfacesMibGet(this.targetip, this.version, this.community);
            mibInterfacesGet.getInitialyzeInterfacesMIB();
            logger.info("SNMP Interfaces Mib Get " + this.targetip);
            if (this.nodeKind.equals("Printer")) {
                SnmpPrintMibGet get = new SnmpPrintMibGet();
                get.setSnmpPrintMibGet(this.targetip, this.version, this.community);
                get.getInitialyzePrintMIB();
                logger.info("SNMP Print Mib Get " + this.targetip);
            }
            if (this.snmpLevel == 2) {
                mibStatisGet = new StatisticsMibDBRegister(this.targetip, this.version, this.community);
                mibStatisGet.setDatabaseStatisMibInfomation("1.3.6.1.2.1.2.2.1.10", Integer.toString(this.period), "0", "");
                mibStatisGet.setDatabaseStatisMibInfomation("1.3.6.1.2.1.2.2.1.16", Integer.toString(this.period), "0", "");
            }
            if (this.snmpLevel == 3) {
                mibStatisGet = new StatisticsMibDBRegister(this.targetip, this.version, this.community);
                mibStatisGet.setDatabaseStatisMibInfomation("1.3.6.1.4.1.2021.10.1.3", Integer.toString(this.period), "0", "");
            }
            if (this.snmpLevel == 4) {
                mibStatisGet = new StatisticsMibDBRegister(this.targetip, this.version, this.community);
                mibStatisGet.setDatabaseStatisMibInfomation("1.3.6.1.4.1.2021.9.1.6", Integer.toString(this.period), "0", "");
                mibStatisGet.setDatabaseStatisMibInfomation("1.3.6.1.4.1.2021.9.1.7", Integer.toString(this.period), "0", "");
                mibStatisGet.setDatabaseStatisMibInfomation("1.3.6.1.4.1.2021.9.1.8", Integer.toString(this.period), "0", "");
            }
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SocketException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (SnmpMIBGetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

