/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public final class MibGetNextInfoQueue {
    private static final int QUEUE_TIMEOUT = 120;
    private static final int BASE_SECOUND_COUNT = 1000;
    private static final int WAIT_COUNT = 5;
    public static final int THREAD_WAIT_COUNT = 5000;
    private static final String BUSY = "busy";
    private static final String UNBUSY = "unbusy";
    private static Map nodeBusyMap = Collections.synchronizedMap(new HashMap());
    private static Map nodeAddressMap = Collections.synchronizedMap(new HashMap());
    private static Map threadNameMap = Collections.synchronizedMap(new HashMap());
    private static List threadNameList = Collections.synchronizedList(new ArrayList());
    private static Logger logger;

    private MibGetNextInfoQueue() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public synchronized void releaseMibGetInstance(String nodeAddressKey, String threadName) {
        nodeBusyMap.put(nodeAddressKey, UNBUSY);
        this.removeThreadName(threadName);
    }

    public synchronized MibGetNextInfo popMibGetInstanceQueue(String nodeAddressKey, String threadName) throws SocketException {
        MibGetNextInfo mibGetInfo = null;
        if (nodeAddressMap.containsKey(nodeAddressKey)) {
            if (((String)nodeBusyMap.get(nodeAddressKey)).equals(BUSY)) {
                return null;
            }
            String getThreadName = this.getThreadName(threadName);
            if (getThreadName != null) {
                nodeBusyMap.put(nodeAddressKey, BUSY);
                mibGetInfo = (MibGetNextInfo)nodeAddressMap.get(nodeAddressKey);
                return mibGetInfo;
            }
            this.setThread(threadName);
            return null;
        }
        mibGetInfo = new MibGetNextInfo();
        nodeAddressMap.put(nodeAddressKey, mibGetInfo);
        nodeBusyMap.put(nodeAddressKey, BUSY);
        return mibGetInfo;
    }

    public synchronized void checkTimeout(String targetIP, String oid, int checkCount, int version) throws SnmpMIBGetException {
        String retryString;
        String socketTimeoutString;
        switch (version) {
            case 0: {
                socketTimeoutString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Timeout();
                retryString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Retry();
                break;
            }
            case 1: {
                socketTimeoutString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Timeout();
                retryString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV2Retry();
                break;
            }
            case 3: {
                socketTimeoutString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV1Timeout();
                retryString = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpV3Retry();
                break;
            }
            default: {
                logger.warning("Bad Snmp version: " + version);
                throw new SnmpMIBGetException("Bad SNMP Version = " + version);
            }
        }
        int timeout = Integer.parseInt(socketTimeoutString);
        int retry = Integer.parseInt(retryString);
        if (checkCount > 120) {
            String message = "Abort get SNMP MIB GetNext Instance. Node IP=" + targetIP + " OID=" + oid + " timeout=" + timeout + " retry=" + retry;
            AlarmMessageMake alarm = AlarmMessageMake.getInstance();
            alarm.setEorrorTest(targetIP, message);
            logger.warning(message);
            throw new SnmpMIBGetException("Abort get MIB IP=" + targetIP + " OID=" + oid);
        }
    }

    public synchronized void setThread(String threadName) {
        if (!threadNameMap.containsKey(threadName)) {
            threadNameList.add(threadName);
            threadNameMap.put(threadName, threadName);
        }
    }

    public synchronized void removeThreadName(String threadName) {
        int i = 0;
        while (i < threadNameList.size()) {
            String removeThredaName = (String)threadNameList.get(i);
            if (threadName.equals(removeThredaName)) {
                threadNameList.remove(i);
            }
            ++i;
        }
        threadNameMap.remove(threadName);
    }

    public synchronized String getThreadName(String threadName) {
        if (threadNameList.size() > 0) {
            String waitThreadName = (String)threadNameList.get(0);
            if (threadName.equals(waitThreadName)) {
                threadNameList.remove(0);
                threadNameMap.remove(threadName);
                return waitThreadName;
            }
            return null;
        }
        return threadName;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static MibGetNextInfoQueue getInstance() {
        return SingletonAboutMessage.MIB_GETNEXT_POOL;
    }

    /* synthetic */ MibGetNextInfoQueue(MibGetNextInfoQueue mibGetNextInfoQueue) {
        this();
    }

    private static class SingletonAboutMessage {
        static final MibGetNextInfoQueue MIB_GETNEXT_POOL = new MibGetNextInfoQueue(null);

        private SingletonAboutMessage() {
        }
    }
}

