/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.statistics;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class ThreadStatisticsMibGet
implements Runnable {
    private static Logger logger;
    private String targetip;
    private int version;
    private String community;
    private String oid;
    private int period;
    private String tableName;

    public ThreadStatisticsMibGet(String targetip, int version, String community, String oid, int period, String tableName) {
        logger = Logger.getLogger(this.getClass().getName());
        this.targetip = targetip;
        this.version = version;
        this.community = community;
        this.oid = oid;
        this.period = period;
        this.tableName = tableName;
    }

    public void run() {
        int count = 0;
        while (true) {
            ++count;
            NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(this.targetip);
            if (nodeInfo.getStatisticsMIBStatus().equals("OK")) break;
            try {
                MibGetNextInfoQueue.getInstance().checkTimeout(this.targetip, "Wait STATISTICS_MIB_OK", count, this.version);
            }
            catch (SnmpMIBGetException e2) {
                logger.warning(e2.getMessage());
                e2.printStackTrace();
                break;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        MibGetNextInfo mibGetInstance = null;
        ArrayList statisList = null;
        try {
            try {
                int checkCount = 0;
                while (mibGetInstance == null) {
                    mibGetInstance = MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(this.targetip, Thread.currentThread().getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    MibGetNextInfoQueue.getInstance().checkTimeout(this.targetip, this.oid, ++checkCount, this.version);
                }
                logger.info("IP Address=" + this.targetip + " Table=" + this.tableName + " Version=" + this.version + " OID=" + this.oid);
                mibGetInstance.setMibGetNext(this.targetip, this.version, this.community);
                statisList = mibGetInstance.getNextMibValueList(this.oid);
                if (statisList != null) {
                    this.setMibStatisticsDatabase(this.tableName, this.oid, statisList);
                }
            }
            catch (UnknownHostException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + this.oid + " Period=" + this.period);
                e.printStackTrace();
            }
            catch (SocketException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + this.oid + " Period=" + this.period);
                e.printStackTrace();
            }
            catch (SnmpMIBGetException e) {
                logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + this.oid + " Period=" + this.period);
                e.printStackTrace();
            }
        }
        finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(this.targetip, Thread.currentThread().getName());
            }
        }
    }

    void setMibStatisticsDatabase(String tableName, String oid, ArrayList statisItemList) {
        if (tableName == null) {
            return;
        }
        try {
            DBTableStatisticsMIBControl statisMibTableControl = DBTableStatisticsMIBControl.getInstance();
            statisMibTableControl.put(tableName, oid, statisItemList);
        }
        catch (DatabaseConnectionException e) {
            logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + oid + " Period=" + this.period);
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.warning(String.valueOf(e.getMessage()) + " IP=" + this.targetip + " Version=" + this.version + " Community=" + this.community + " OID=" + oid + " Period=" + this.period);
            e.printStackTrace();
        }
    }
}

