/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.messageformat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;

public class SnmpTrap2PDU
extends SnmpSequence {
    public SnmpTrap2PDU(long agentStartTime, String snmpTrapOidValueString, SnmpVariablePair variablePair) throws SnmpBadValueException {
        this.tag = (byte)-89;
        List<SnmpSequence> trapContentsList = Collections.synchronizedList(new ArrayList());
        SnmpSequence varBindList = new SnmpSequence();
        SnmpObjectIdentifier snmpSysupTimeOID = new SnmpObjectIdentifier("1.3.6.1.2.1.1.3.0");
        SnmpTimeTicks sysUpTime = new SnmpTimeTicks(agentStartTime);
        varBindList.addSNMPObject(new SnmpVariablePair(snmpSysupTimeOID, sysUpTime));
        SnmpObjectIdentifier snmpTrapOID = new SnmpObjectIdentifier("1.3.6.1.6.3.1.1.4.1.0");
        SnmpObjectIdentifier snmpTrapOIDValue = new SnmpObjectIdentifier(snmpTrapOidValueString);
        varBindList.addSNMPObject(new SnmpVariablePair(snmpTrapOID, snmpTrapOIDValue));
        varBindList.addSNMPObject(variablePair);
        trapContentsList.add(varBindList);
        this.setValue(trapContentsList);
    }

    public SnmpTrap2PDU(SnmpObjectIdentifier enterpriseOID, SnmpIPAddress agentAddress, int genericTrap, int specificTrap, SnmpTimeTicks timestamp) throws SnmpBadValueException {
        this.tag = (byte)-89;
        List<AbstractSnmpObject> contents = Collections.synchronizedList(new ArrayList());
        contents.add(enterpriseOID);
        contents.add(agentAddress);
        contents.add(new SnmpInteger(genericTrap));
        contents.add(new SnmpInteger(specificTrap));
        contents.add(timestamp);
        contents.add(new SnmpVarBindList());
        this.setValue(contents);
    }

    public SnmpTrap2PDU(byte[] enc) throws SnmpBadValueException {
        this.tag = (byte)-89;
        this.extractFromBEREncoding(enc);
    }

    public void setPDU(int requestID, int errorStatus, int errorIndex) {
        this.sequenceList.add(0, new SnmpInteger(requestID));
        this.sequenceList.add(1, new SnmpInteger(errorStatus));
        this.sequenceList.add(2, new SnmpInteger(errorIndex));
    }

    public byte getPDUType() {
        return this.tag;
    }

    public SnmpSequence getVarBindList() {
        List contents = (List)this.getValue();
        return (SnmpSequence)contents.get(5);
    }

    public SnmpObjectIdentifier getEnterpriseOID() {
        List contents = (List)this.getValue();
        return (SnmpObjectIdentifier)contents.get(0);
    }

    public SnmpIPAddress getAgentAddress() {
        List contents = (List)this.getValue();
        if (contents.get(1) instanceof SnmpIPAddress) {
            return (SnmpIPAddress)contents.get(1);
        }
        return null;
    }

    public int getGenericTrap() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(2)).getValue()).intValue();
    }

    public int getSpecificTrap() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(3)).getValue()).intValue();
    }

    public long getTimestamp() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpTimeTicks)contents.get(4)).getValue()).longValue();
    }
}

