/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.opaque;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaqueCounter64;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaqueDouble;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaqueFloat;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaqueInteger64;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaqueUnsigned64;

public class SnmpOpaque
extends AbstractSnmpObject {
    public static final byte MASK_0XFF = -1;
    public static final int LEN = 2;
    public static final int DATA = 3;
    private static Logger logger;
    private AbstractSnmpObject snmpObj = null;

    public SnmpOpaque() {
        logger = Logger.getLogger(this.getClass().getName());
        this.tag = (byte)68;
        this.tagDescription = "OPAQUE";
    }

    public SnmpOpaque(byte[] enc) throws SnmpBadValueException {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("SnmpOpaque");
        this.extractValueFromBEREncoding(enc);
        this.tag = (byte)68;
        this.tagDescription = "OPAQUE";
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;
        try {
            byte[] data = this.snmpObj.getBEREncoding();
            byte[] len = this.encodeLength(data.length);
            outBytes.write(this.tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    public void extractValueFromBEREncoding(byte[] enc) throws SnmpBadValueException {
        block8: {
            block7: {
                if (enc[0] != -97) break block7;
                byte len2 = enc[2];
                switch (enc[1]) {
                    case 118: {
                        logger.info("OPAQUE_COUNTER64");
                        this.snmpObj = new SnmpOpaqueCounter64(enc, 3, len2);
                        break block8;
                    }
                    case 120: {
                        logger.info("OPAQUE_FLOAT");
                        this.snmpObj = new SnmpOpaqueFloat(enc, 3, len2);
                        break block8;
                    }
                    case 121: {
                        logger.info("OPAQUE_DOUBLE");
                        this.snmpObj = new SnmpOpaqueDouble(enc, 3, len2);
                        break block8;
                    }
                    case 122: {
                        logger.info("OPAQUE_INTEGER64");
                        this.snmpObj = new SnmpOpaqueInteger64(enc, 3, len2);
                        break block8;
                    }
                    case 123: {
                        logger.info("OPAQUE_UNSIGNED64");
                        this.snmpObj = new SnmpOpaqueUnsigned64(enc, 3, len2);
                        break block8;
                    }
                    default: {
                        logger.warning("Unknown OPAQUE type");
                        throw new SnmpBadValueException("Unknown OPAQUE type");
                    }
                }
            }
            logger.warning("OPAQUE format error");
            throw new SnmpBadValueException("OPAQUE format error");
        }
    }

    public void setValue(Object newValue) throws SnmpBadValueException {
    }

    public Object getValue() {
        return this.snmpObj;
    }

    public String toString() {
        String returnString = this.snmpObj.toString();
        return returnString;
    }
}

