/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.opaque;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaque;

public class SnmpOpaqueUnsigned64
extends SnmpOpaque {
    private long opaqueUnsigned64Value;

    protected SnmpOpaqueUnsigned64(long value) {
        this.opaqueUnsigned64Value = value;
    }

    protected SnmpOpaqueUnsigned64(byte[] data, int offset, int length) throws SnmpBadValueException {
        this.opaqueUnsigned64Value = this.decode(data, offset, length);
    }

    public byte[] encode() {
        return this.encode(this.opaqueUnsigned64Value);
    }

    public byte[] encode(long value) {
        List<Byte> valueList = Collections.synchronizedList(new ArrayList());
        valueList.add(new Byte(0));
        valueList.add(new Byte((byte)(value >> 56 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value >> 48 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value >> 40 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value >> 32 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value >> 24 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value >> 16 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value >> 8 & 0xFFFFFFFFFFFFFFFFL)));
        valueList.add(new Byte((byte)(value & 0xFFFFFFFFFFFFFFFFL)));
        int i = 0;
        while (i < 8) {
            byte b = (Byte)valueList.get(1);
            if (b != 0) {
                if (b < 0) break;
                valueList.remove(0);
                break;
            }
            valueList.remove(0);
            ++i;
        }
        int length = valueList.size();
        byte[] array = new byte[5 + length];
        array[0] = 68;
        array[1] = (byte)(length + 3);
        array[2] = -97;
        array[3] = 123;
        array[4] = (byte)length;
        int i2 = 0;
        while (i2 < length) {
            array[5 + i2] = (Byte)valueList.get(i2);
            ++i2;
        }
        valueList.clear();
        return array;
    }

    public long decode(byte[] data, int offset, int length) throws SnmpBadValueException {
        if (length < 1) {
            throw new SnmpBadValueException(new StringBuffer().append("length too short: ").append(length).append(" < 1").toString());
        }
        if (length > 9) {
            throw new SnmpBadValueException(new StringBuffer().append("length too long: ").append(length).append(" > 9").toString());
        }
        long longValue = 0L;
        try {
            int i = 0;
            while (i < length) {
                longValue <<= 8;
                longValue |= (long)(data[offset + i] & 0xFFFFFFFF);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }
        return longValue;
    }

    public Object getValue() {
        Long valued = new Long(this.opaqueUnsigned64Value);
        return valued;
    }

    public String toString() {
        return Long.toString(this.opaqueUnsigned64Value);
    }
}

