/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.io.FileNotFoundException;
import java.net.SocketException;
import java.net.URL;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmpagent.AgentCommunicationMonitorView;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.model.AgentDataImportException;
import netjfwatcher.snmpagent.process.ThreadAgent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

public class ActionBuilderAgentTable {
    private Table agentTable;
    private SubStatusLineManager statusLineManager;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction startAgentAction = new ActionAgentStart();
    private IAction stopAgentAction = new ActionStopAgent();
    private IAction restartAgentAction = new ActionRestartAgent();
    private IAction importAgentFileAction = new ActionAgentImportFile();
    private IAction monitorStartAction = new ActionAgentMonitorStart();
    private IAction monitorStopAction = new ActionAgentMonitorStop();
    private IAction monitorRestartAction = new ActionAgentMonitorRestart();

    public ActionBuilderAgentTable(Table agentTable, SubStatusLineManager statusLineManager) {
        this.agentTable = agentTable;
        this.statusLineManager = statusLineManager;
    }

    public IAction actionStartAgent() {
        return this.startAgentAction;
    }

    public IAction actionStopAgent() {
        return this.stopAgentAction;
    }

    public IAction actionRestartAgent() {
        return this.restartAgentAction;
    }

    public IAction actionImportAgentFile() {
        return this.importAgentFileAction;
    }

    public IAction actionMonitorStart() {
        return this.monitorStartAction;
    }

    public IAction actionMonitorStop() {
        return this.monitorStopAction;
    }

    public IAction actionMonitorRestart() {
        return this.monitorRestartAction;
    }

    static /* synthetic */ Table access$2(ActionBuilderAgentTable actionBuilderAgentTable) {
        return actionBuilderAgentTable.agentTable;
    }

    private abstract class AbstractNodeAction
    extends Action {
        private AbstractNodeAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    private final class ActionAgentStart
    extends AbstractNodeAction {
        private ActionAgentStart() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/agent.gif"));
        }

        public String getText() {
            return "Agent Start";
        }

        public String getToolTipText() {
            return "Agent\u52d5\u4f5c\u3092\u958b\u59cb\u3057\u307e\u3059";
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void doTask() {
            Shell shell;
            block10: {
                shell = new Shell();
                MessageBox alertMessageVox = new MessageBox(shell, 72);
                if (ThreadAgent.getInstance().checkThread()) {
                    alertMessageVox.setMessage("Already agent thraed alive");
                    alertMessageVox.open();
                    ActionBuilderAgentTable.this.statusLineManager.setMessage("Agent thread status is active");
                    shell.dispose();
                    return;
                }
                try {
                    if (ThreadAgent.getInstance().startThread(true)) break block10;
                    alertMessageVox.setMessage("Abort agnet thread start");
                    alertMessageVox.open();
                }
                catch (Throwable throwable) {
                    if (shell != null) {
                        shell.dispose();
                    }
                    throw throwable;
                }
                {
                    catch (SocketException e) {
                        alertMessageVox.setMessage(e.getMessage());
                        alertMessageVox.open();
                        ActionBuilderAgentTable.this.statusLineManager.setMessage("Agent thread status is active");
                    }
                }
                if (shell != null) {
                    shell.dispose();
                }
                return;
            }
            if (shell != null) {
                shell.dispose();
            }
            ActionBuilderAgentTable.this.statusLineManager.setMessage("Agent thread status is active");
            if (NetJFWatcherApplication.getAgentOperationView() != null) {
                NetJFWatcherApplication.getAgentOperationView().setText();
                NetJFWatcherApplication.getAgentOperationView().setSysupTime();
            }
        }
    }

    private final class ActionStopAgent
    extends AbstractNodeAction {
        private ActionStopAgent() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/agentstop.gif"));
        }

        public String getText() {
            return "Stop Agent";
        }

        public String getToolTipText() {
            return "Agent\u3092\u505c\u6b62\u3057\u307e\u3059";
        }

        protected void doTask() {
            ThreadAgent.getInstance().stopReceiving();
            ActionBuilderAgentTable.this.statusLineManager.setMessage("Agent thread status is stop");
        }
    }

    private final class ActionRestartAgent
    extends AbstractNodeAction {
        private ActionRestartAgent() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/agentrestart.gif"));
        }

        public String getText() {
            return "Agent\u518d\u8d77\u52d5";
        }

        public String getToolTipText() {
            return "Agent\u3092\u518d\u8d77\u52d5\u3057\u307e\u3059";
        }

        protected void doTask() {
            ThreadAgent.getInstance().stopReceiving();
            try {
                if (!ThreadAgent.getInstance().startThread(true)) {
                    Shell shell = new Shell();
                    MessageBox alertMessageVox = new MessageBox(shell, 72);
                    alertMessageVox.setMessage("Abort agnet thread restart");
                    alertMessageVox.open();
                    shell.dispose();
                    return;
                }
                ActionBuilderAgentTable.this.statusLineManager.setMessage("Agent thread status is active");
            }
            catch (SocketException e) {
                Shell shell = new Shell();
                MessageBox alertMessageVox = new MessageBox(shell, 72);
                alertMessageVox.setMessage(e.getMessage());
                alertMessageVox.open();
                shell.dispose();
                return;
            }
        }
    }

    private final class ActionAgentImportFile
    extends AbstractNodeAction {
        private ActionAgentImportFile() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/import_wiz.gif"));
        }

        public String getText() {
            return "Import Agent file";
        }

        public String getToolTipText() {
            return "Agent file\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002";
        }

        /*
         * Unable to fully structure code
         */
        protected void doTask() {
            shell = new Shell();
            openDialog = new FileDialog(shell, 4096);
            openFileName = openDialog.open();
            if (openFileName != null) {
                ThreadAgent.getInstance().stopReceiving();
                ActionBuilderAgentTable.access$2(ActionBuilderAgentTable.this).removeAll();
                view = NetJFWatcherApplication.getAgentTableView().getViewer();
                view.refresh();
                AgentMibTree.getInstance().reloadOidTree("resources/AgentMibDefined.tbl");
                importData = new AgentDataImport();
                resultSetAgentDataMessage = "";
                try {
                    try {
                        resultSetAgentDataMessage = importData.setAgentData(openFileName);
                        if (!resultSetAgentDataMessage.equals("")) {
                            infoMessageBox = new MessageBox(shell, 66);
                            infoMessageBox.setMessage(resultSetAgentDataMessage);
                            infoMessageBox.open();
                        }
                    }
                    catch (FileNotFoundException e) {
                        alertMessageBox = new MessageBox(shell, 72);
                        alertMessageBox.setMessage(e.getMessage());
                        alertMessageBox.open();
                        e.printStackTrace();
lbl27:
                        // 2 sources

                        while (true) {
                            shell.dispose();
                            return;
                        }
                    }
                    catch (AgentDataImportException e) {
                        alertMessageBox = new MessageBox(shell, 72);
                        alertMessageBox.setMessage(e.getMessage());
                        alertMessageBox.open();
                        e.printStackTrace();
                        ** continue;
                    }
                }
                finally {
                    shell.dispose();
                }
                try {
                    try {
                        shell = new Shell();
                        ThreadAgent.getInstance().startThread(true);
                    }
                    catch (SocketException e) {
                        alertMessageBox = new MessageBox(shell, 72);
                        alertMessageBox.setMessage(e.getMessage());
                        alertMessageBox.open();
                        e.printStackTrace();
                        shell.dispose();
                        return;
                    }
                }
                finally {
                    shell.dispose();
                }
            }
        }
    }

    private final class ActionAgentMonitorStart
    extends AbstractNodeAction {
        private ActionAgentMonitorStart() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/monitor.gif"));
        }

        public String getText() {
            return "Monitor\u3092Start";
        }

        public String getToolTipText() {
            return "Monitor\u3092Start\u3057\u307e\u3059\u3002";
        }

        protected void doTask() {
            AgentCommunicationMonitorView.TimerProcessorThread timerProcessor = NetJFWatcherApplication.getAgentCommunicationMonitorView().getTimerProcessor();
            NetJFWatcherApplication.getAgentCommunicationMonitorView().getDisplay().timerExec(1000, (Runnable)timerProcessor);
        }
    }

    private final class ActionAgentMonitorStop
    extends AbstractNodeAction {
        private ActionAgentMonitorStop() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/monitorstop.gif"));
        }

        public String getText() {
            return "Monitor\u3092Stop";
        }

        public String getToolTipText() {
            return "Monitor\u3092Stop\u3057\u307e\u3059\u3002";
        }

        protected void doTask() {
            AgentCommunicationMonitorView.TimerProcessorThread timerProcessor = NetJFWatcherApplication.getAgentCommunicationMonitorView().getTimerProcessor();
            NetJFWatcherApplication.getAgentCommunicationMonitorView().getDisplay().timerExec(-1, (Runnable)timerProcessor);
        }
    }

    private final class ActionAgentMonitorRestart
    extends AbstractNodeAction {
        private ActionAgentMonitorRestart() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderAgentTable.this.bundle.getEntry("icons/monitorrestart.gif"));
        }

        public String getText() {
            return "Monitor\u3092Restart";
        }

        public String getToolTipText() {
            return "Monitor\u3092Restart\u3057\u307e\u3059\u3002";
        }

        protected void doTask() {
            AgentCommunicationMonitorView.TimerProcessorThread timerProcessor = NetJFWatcherApplication.getAgentCommunicationMonitorView().getTimerProcessor();
            NetJFWatcherApplication.getAgentCommunicationMonitorView().getDisplay().timerExec(-1, (Runnable)timerProcessor);
            NetJFWatcherApplication.getAgentCommunicationMonitorView().getDisplay().timerExec(1000, (Runnable)timerProcessor);
        }
    }
}

