/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.io.FileNotFoundException;
import java.net.SocketException;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpagent.ActionBuilderAgentTable;
import netjfwatcher.snmpagent.AgentTableViewContentProvider;
import netjfwatcher.snmpagent.AgentTableViewLabelProvider;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.model.AgentDataImportException;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.model.AgentTableListener;
import netjfwatcher.snmpagent.process.ThreadAgent;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class AgentTableView
extends AbstractTableView {
    public static final String AGENT_THREAD_ALIVE_MESSAGE = "Agent thread status is active";
    public static final String AGENT_THREAD_DEAD_MESSAGE = "Agent thread status is stop";
    private static final int AGENT_INSTANCE_CHECK_THREAD_TIMER = 1000;
    private static boolean isCol0Direction = false;
    private static boolean isCol1Direction = true;
    private static boolean isCol2Direction = true;
    private static boolean isCol3Direction = true;
    private static boolean isCol4Direction = true;
    private static boolean isCol5Direction = true;
    private TableColumn col0;
    private TableColumn col1;
    private TableColumn col2;
    private TableColumn col3;
    private TableColumn col4;
    private TableColumn col5;
    private static Logger logger = null;
    private static final float COLUM0_INSTANCE_NO_RATIO = 0.03f;
    private static final float COLUM1_OID_DESC_RATIO = 0.25f;
    private static final float COLUM2_OID_RATIO = 0.15f;
    private static final float COLUM3_VALUE_RATIO = 0.35f;
    private static final float COLUM4_TYPE_RATIO = 0.1f;
    private static final float COLUM5_ACCESS_RATIO = 0.1f;
    private Display display;
    private AgentTableShowTimerProcessor agentTableShowThread;
    private Table mibInstnaceTable;
    private TableViewer viewer;
    private SubStatusLineManager statusLineManager;
    private ActionBuilderAgentTable actionAgentTableBuilder;

    public AgentTableView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public ActionBuilderAgentTable getActionBuilder() {
        return this.actionAgentTableBuilder;
    }

    public void setFocus() {
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.agentTableShowThread = new AgentTableShowTimerProcessor();
        this.display = parent.getDisplay();
        this.display.timerExec(1000, (Runnable)this.agentTableShowThread);
        this.createTable(parent);
        this.viewer = new TableViewer(this.mibInstnaceTable);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new AgentTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AgentTableViewLabelProvider());
        this.actionAgentTableBuilder = new ActionBuilderAgentTable(this.mibInstnaceTable, this.statusLineManager);
        this.createContextMenu();
        this.initActions();
        String csvFile = "resources/defaultAgent.csv";
        AgentDataImport importAgentData = new AgentDataImport();
        try {
            importAgentData.setDefaultAgentData(csvFile, this.mibInstnaceTable);
        }
        catch (FileNotFoundException e) {
            logger.warning("Snmp agent initial error " + e.getMessage());
            MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
            alertMessageBox.setMessage("Snmp agent initial error " + e.getMessage());
            alertMessageBox.open();
            e.printStackTrace();
        }
        catch (AgentDataImportException e) {
            logger.warning("Snmp agent initial error " + e.getMessage());
            MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
            alertMessageBox.setMessage("Snmp agent initial error " + e.getMessage());
            alertMessageBox.open();
            e.printStackTrace();
        }
        this.startAgent();
    }

    private void startAgent() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        ThreadAgent agentThread = ThreadAgent.getInstance();
        boolean isSuccessAgentThread = false;
        try {
            isSuccessAgentThread = agentThread.startThread(false);
        }
        catch (SocketException e1) {
            MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
            alertMessageBox.setMessage("Abort start SNMP Agent : " + e1.getMessage());
            alertMessageBox.open();
            if (agentThread.checkThread()) {
                this.statusLineManager.setMessage(AGENT_THREAD_ALIVE_MESSAGE);
            } else {
                this.statusLineManager.setMessage(AGENT_THREAD_DEAD_MESSAGE);
            }
            return;
        }
        if (!isSuccessAgentThread && this.getSite().getPage().isPartVisible(this.getSite().getPart())) {
            MessageBox alertMessageBox = new MessageBox(this.getViewSite().getShell(), 72);
            alertMessageBox.setMessage("Abort agent start");
            alertMessageBox.open();
        }
        if (agentThread.checkThread()) {
            this.statusLineManager.setMessage(AGENT_THREAD_ALIVE_MESSAGE);
        } else {
            this.statusLineManager.setMessage(AGENT_THREAD_DEAD_MESSAGE);
        }
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.03f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.25f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.15f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.35f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private void createTable(Composite parent) {
        this.mibInstnaceTable = new Table(parent, 66304);
        this.mibInstnaceTable.setLinesVisible(true);
        this.mibInstnaceTable.setHeaderVisible(true);
        this.col0 = new TableColumn(this.mibInstnaceTable, 16384);
        this.col0.setText(AgentTableViewLabelProvider.COLUMNS[0]);
        this.col0.setWidth(this.computeCol0Width());
        this.col1 = new TableColumn(this.mibInstnaceTable, 16384);
        this.col1.setText(AgentTableViewLabelProvider.COLUMNS[1]);
        this.col1.setWidth(this.computeCol1Width());
        this.col2 = new TableColumn(this.mibInstnaceTable, 16384);
        this.col2.setText(AgentTableViewLabelProvider.COLUMNS[2]);
        this.col2.setWidth(this.computeCol1Width());
        this.col3 = new TableColumn(this.mibInstnaceTable, 16384);
        this.col3.setText(AgentTableViewLabelProvider.COLUMNS[3]);
        this.col3.setWidth(this.computeCol1Width());
        this.col4 = new TableColumn(this.mibInstnaceTable, 16384);
        this.col4.setText(AgentTableViewLabelProvider.COLUMNS[4]);
        this.col4.setWidth(this.computeCol1Width());
        this.col5 = new TableColumn(this.mibInstnaceTable, 16384);
        this.col5.setText(AgentTableViewLabelProvider.COLUMNS[5]);
        this.col5.setWidth(this.computeCol1Width());
        this.mibInstnaceTable.addSelectionListener((SelectionListener)new AgentTableListener(this.mibInstnaceTable));
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                AgentTableView.this.setResizedTableColumnWidth();
            }
        });
        this.col0.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol0Direction = AgentTableView.this.sortIntegerTable(AgentTableView.this.mibInstnaceTable, 0, isCol0Direction);
            }
        });
        this.col1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol1Direction = AgentTableView.this.sortTable(AgentTableView.this.mibInstnaceTable, 1, isCol1Direction);
            }
        });
        this.col2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol2Direction = AgentTableView.this.sortTable(AgentTableView.this.mibInstnaceTable, 2, isCol2Direction);
            }
        });
        this.col3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol3Direction = AgentTableView.this.sortTable(AgentTableView.this.mibInstnaceTable, 3, isCol3Direction);
            }
        });
        this.col4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol4Direction = AgentTableView.this.sortTable(AgentTableView.this.mibInstnaceTable, 4, isCol4Direction);
            }
        });
        this.col5.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol5Direction = AgentTableView.this.sortTable(AgentTableView.this.mibInstnaceTable, 5, isCol5Direction);
            }
        });
    }

    protected void setResizedTableColumnWidth() {
        if (this.getSite().getPage().isPartVisible(this.getSite().getPart()) && this.getSite().getShell() != null && this.getSite().getShell().getSize() != null) {
            this.col0.setWidth(this.computeCol0Width());
            this.col1.setWidth(this.computeCol1Width());
            this.col2.setWidth(this.computeCol2Width());
            this.col3.setWidth(this.computeCol3Width());
            this.col4.setWidth(this.computeCol4Width());
            this.col5.setWidth(this.computeCol5Width());
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionBuilder().actionStartAgent());
        manager.add(this.getActionBuilder().actionStopAgent());
        manager.add(this.getActionBuilder().actionImportAgentFile());
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AgentTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionBuilder().actionRestartAgent());
        toolBarManager.add(this.getActionBuilder().actionStopAgent());
        toolBarManager.add(this.getActionBuilder().actionStartAgent());
        toolBarManager.add(this.getActionBuilder().actionImportAgentFile());
    }

    public Table getTable() {
        return this.mibInstnaceTable;
    }

    public class AgentTableShowTimerProcessor
    implements Runnable {
        public void run() {
            Object object = AgentInstanceDataRefreshQueue.getInstance().popAgentQueue();
            if (object != null) {
                AgentTableView.this.mibInstnaceTable.removeAll();
                Map tableAgentMap = AgentInstanceDataMap.getInstance().getAgentInstanceMap();
                for (Map.Entry ent : tableAgentMap.entrySet()) {
                    String rowOid = (String)ent.getKey();
                    MibInfo oidInfo = (MibInfo)tableAgentMap.get(rowOid);
                    String[] mib = new String[]{Integer.toString(oidInfo.getInstanceNo()), oidInfo.getDescrip(), oidInfo.getOid(), oidInfo.getValue(), oidInfo.getSyntax(), oidInfo.getAccess().equals("ro") ? "read-only" : (oidInfo.getAccess().equals("rw") ? "read-write" : "not-accessible")};
                    TableItem tableItem = new TableItem(AgentTableView.this.mibInstnaceTable, 0);
                    tableItem.setText(mib);
                    tableItem.setData((Object)mib);
                }
                AgentTableView.this.mibInstnaceTable.redraw();
                AgentTableView.this.sortIntegerTable(AgentTableView.this.mibInstnaceTable, 0, false);
            }
            AgentTableView.this.display.timerExec(1000, (Runnable)this);
        }
    }
}

