/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpagent.process.UsmStatistics;

public class AgentV3Report {
    private static Logger logger;

    public AgentV3Report() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public SnmpPDU sendUnsupportedSecurityLevelReport(int retoriveID) throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning("Unsupported security level : 1.3.6.1.6.3.15.1.1.1.0");
        try {
            UsmStatistics.getInstance().addUsmStatsUnsupportedSecLevels();
            SnmpCounter32 statistics = new SnmpCounter32(UsmStatistics.getInstance().getUsmStatsUnsupportedSecLevels());
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.1.0");
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, statistics);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPduData = new SnmpPDU(-88, retoriveID, 0, 0, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create PDU of UnsupportedSecLevels " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return reportPduData;
    }

    public SnmpPDU sendUnknownUserNamesReport(int retoriveID) throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning("Unknown engine ID : 1.3.6.1.6.3.15.1.1.4.0");
        try {
            UsmStatistics.getInstance().addUsmStatsUnknownUserNames();
            SnmpCounter32 statistics = new SnmpCounter32(UsmStatistics.getInstance().getUsmStatsUnknownUserNames());
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.3.0");
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, statistics);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPduData = new SnmpPDU(-88, retoriveID, 0, 0, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create PDU of UnknownUserNames " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return reportPduData;
    }

    public SnmpPDU sendUnknownEngineIDReport(int retoriveID) throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning("Unknown engine ID : 1.3.6.1.6.3.15.1.1.4.0");
        try {
            UsmStatistics.getInstance().addUsmStatsUnknownEngineIDs();
            SnmpCounter32 statistics = new SnmpCounter32(UsmStatistics.getInstance().getUsmStatsUnknownEngineIDs());
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.4.0");
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, statistics);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPduData = new SnmpPDU(-88, retoriveID, 0, 0, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create PDU of UnknownEngineIDs " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return reportPduData;
    }

    public SnmpPDU sendNotInTimeWindowsReport(int retoriveID) throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning("Unknown engine ID : 1.3.6.1.6.3.15.1.1.4.0");
        try {
            UsmStatistics.getInstance().addUsmStatsNotInTimeWindows();
            SnmpCounter32 statistics = new SnmpCounter32(UsmStatistics.getInstance().getUsmStatsNotInTimeWindows());
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.2.0");
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, statistics);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPduData = new SnmpPDU(-88, retoriveID, 0, 0, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create PDU of NotInTimeWindows " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return reportPduData;
    }

    public SnmpPDU sendWrongDigestsReport(int retoriveID) throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning("Wrong digest : 1.3.6.1.6.3.15.1.1.5.0");
        try {
            UsmStatistics.getInstance().addUsmStatsWrongDigests();
            SnmpCounter32 statistics = new SnmpCounter32(UsmStatistics.getInstance().getUsmStatsWrongDigests());
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.5.0");
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, statistics);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPduData = new SnmpPDU(-88, retoriveID, 0, 0, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create PDU of WrongDigests " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return reportPduData;
    }

    public SnmpPDU sendDecryptionErrorReport(int retoriveID) throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning("Descryption error : 1.3.6.1.6.3.15.1.1.6.0");
        try {
            UsmStatistics.getInstance().addUsmStatsDecryptionErrors();
            SnmpCounter32 statistics = new SnmpCounter32(UsmStatistics.getInstance().getUsmStatsDecryptionErrors());
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.6.0");
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, statistics);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPduData = new SnmpPDU(-88, retoriveID, 0, 0, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create PDU of Decryption Errors " + e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return reportPduData;
    }
}

