/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpmanager.SnmpV1ValueTypeSelection;
import netjfwatcher.snmpmanager.SnmpV2ValueTypeSelection;
import netjfwatcher.snmpmanager.SnmpV3ValueTypeSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeItem;

public final class OidTreeListener
implements SelectionListener {
    public static final String READ_ONLY_CODE = "ro";
    public static final String READ_WRITE_CODE = "rw";
    public static final String NOT_ACCESSIBLE_CODE = "n";
    public static final String READ_ONLY_DESCRIPTION = "read-only";
    public static final String READ_WRITE_DESCRIPTION = "read-write";
    public static final String NOT_ACCESSIBLE_DESCRIPTION = "not-accessible";

    private OidTreeListener() {
    }

    public void widgetSelected(SelectionEvent event) {
        TreeItem item = (TreeItem)event.item;
        if (item == null) {
            return;
        }
        MibInfo oidInfo = (MibInfo)item.getData();
        this.updateManagerOperationView(oidInfo);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private void updateManagerOperationView(MibInfo oidInfo) {
        NetJFWatcherApplication.getSnmpV1OperationView().getOidText().setText(oidInfo.getOid());
        NetJFWatcherApplication.getSnmpV2OperationView().getOidText().setText(oidInfo.getOid());
        NetJFWatcherApplication.getSnmpV3OperationView().getOidText().setText(oidInfo.getOid());
        String valueTypeString = "OCTETSTRING";
        String oidType = oidInfo.getSyntax();
        if (oidType.equals("INTEGER")) {
            valueTypeString = "INTEGER";
        } else if (oidType.equals("Counter32")) {
            valueTypeString = "COUNTER32";
        } else if (oidType.equals("Counter64")) {
            valueTypeString = "COUNTER64";
        } else if (oidType.equals("Gauge32")) {
            valueTypeString = "GAUGE32";
        } else if (oidType.equals("OctetString")) {
            valueTypeString = "OCTETSTRING";
        } else if (oidType.equals("IpAddress")) {
            valueTypeString = "IPADDRESS";
        } else if (oidType.equals("ObjectID")) {
            valueTypeString = "OBJECTIDENTIFIER";
        } else if (oidType.equals("TimeTicks")) {
            valueTypeString = "TIMETICKS";
        } else if (oidType.equals("Uinteger32")) {
            valueTypeString = "INTEGER32";
        } else if (oidType.equals("Bits")) {
            valueTypeString = "BITSTRING";
        } else if (oidType.equals("Opaque")) {
            valueTypeString = "OPAQUE";
        } else if (oidType.equals("DisplayString")) {
            valueTypeString = "OCTETSTRING";
        }
        NetJFWatcherApplication.getSnmpV1OperationView().getSetValueText().setText("");
        NetJFWatcherApplication.getSnmpV2OperationView().getSetValueText().setText("");
        NetJFWatcherApplication.getSnmpV3OperationView().getSetValueText().setText("");
        NetJFWatcherApplication.getSnmpV1OperationView().getSnmpValueTypeCombo().setText(valueTypeString);
        NetJFWatcherApplication.getSnmpV2OperationView().getSnmpValueTypeCombo().setText(valueTypeString);
        NetJFWatcherApplication.getSnmpV3OperationView().getSnmpValueTypeCombo().setText(valueTypeString);
        if (oidInfo.getAccess().equals(READ_ONLY_CODE)) {
            NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText().setText(READ_ONLY_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText().setText(READ_ONLY_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText().setText(READ_ONLY_DESCRIPTION);
        } else if (oidInfo.getAccess().equals(READ_WRITE_CODE)) {
            NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText().setText(READ_WRITE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText().setText(READ_WRITE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText().setText(READ_WRITE_DESCRIPTION);
        } else {
            NetJFWatcherApplication.getSnmpV1OperationView().getAccessTypeText().setText(NOT_ACCESSIBLE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV2OperationView().getAccessTypeText().setText(NOT_ACCESSIBLE_DESCRIPTION);
            NetJFWatcherApplication.getSnmpV3OperationView().getAccessTypeText().setText(NOT_ACCESSIBLE_DESCRIPTION);
        }
        SnmpV1ValueTypeSelection.getInstance().setSnmpValueType(valueTypeString);
        SnmpV2ValueTypeSelection.getInstance().setSnmpValueType(valueTypeString);
        SnmpV3ValueTypeSelection.getInstance().setSnmpValueType(valueTypeString);
    }

    public static OidTreeListener getInstance() {
        return SingletonResource.LISTENER;
    }

    /* synthetic */ OidTreeListener(OidTreeListener oidTreeListener) {
        this();
    }

    private static class SingletonResource {
        static final OidTreeListener LISTENER = new OidTreeListener(null);

        private SingletonResource() {
        }
    }
}

