/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.nodetree;

import java.util.logging.Logger;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.BrowserEditors;
import netjfwatcher.webbrowser.view.BrowserEditorsManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NodeTreeListener
implements ISelectionChangedListener {
    private static IWorkbenchPage activePage;
    private static Logger logger;
    private static String accessURL;

    static {
        logger = null;
        accessURL = null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        logger = Logger.getLogger(this.getClass().getName());
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        logger.info("Tree node  select : " + ss.getFirstElement());
        if (ss.getFirstElement() instanceof NodeTreeGroup) {
            logger.info("NodeTreeGroup ");
            return;
        }
        if (!(ss.getFirstElement() instanceof NodeTree)) {
            logger.info("No NodeTree ");
            return;
        }
        final NodeTree entry = (NodeTree)ss.getFirstElement();
        try {
            accessURL = entry.getUrl();
        }
        catch (HttpAccessPreferenceException e1) {
            e1.printStackTrace();
        }
        logger.info("Name : " + entry.getName());
        logger.info("Url : " + accessURL);
        activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = BrowserEditorsManager.getInstance().getBrowserEditors(accessURL);
        if (editorPart != null) {
            BrowserEditorsManager.getInstance().removetBrowserEditors(accessURL);
            activePage.closeEditor(editorPart, false);
        }
        if (accessURL != null) {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        IEditorPart editorPart = activePage.openEditor((IEditorInput)new UrlEditorInput(entry.getName(), accessURL), BrowserEditors.class.getName());
                        BrowserEditorsManager.getInstance().setBrowserEditors(accessURL, editorPart);
                    }
                    catch (PartInitException e) {
                        logger.warning("Menu open error : " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        } else {
            logger.warning("Error entry url null");
        }
    }
}

