/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.preferences;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HttpAccessPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String WEB_PREFERENCE = "resources/webAccess.pref";
    public static final String HTTP_HOST_KEY = "HTTP_HOST";
    public static final String HTTP_PORT_KEY = "HTTP_PORT";
    public static final String HTTP_CONTEXT_KEY = "HTTP_CONTEXT";
    public static final String DEFAULT_HTTP_HOST_DATA = "127.0.0.1";
    public static final String DEFAULT_HTTP_PORT_DATA = "8080";
    public static final String DEFAULT_HTTP_CONTEXT_DATA = "netjfwatcher";
    public static final String HTTP_URL_KEY = "HTTP_URL";
    private static final String HTTP_HOST_LABEL = "HTTP HOST";
    private static final String HTTP_PORT_LABEL = "HTTP PORT";
    private static final String HTTP_CONTEXT_LABEL = "CONTEXT";
    private static final String HTTP_URL_LABEL = "URL";
    private static Logger logger;
    private static final int HTTP_HOST_TEXT_WIDTH = 150;
    private static final int HTTP_PORT_TEXT_WIDTH = 50;
    private static final int HTTP_CONTEXT_TEXT_WIDTH = 150;
    private static final int HTTP_URL_TEXT_WIDTH = 300;
    private static final int HORIZONTALSPAN = 4;
    private Text httpHost;
    private Text httpPort;
    private Text httpContext;
    private Text httpUrltext;
    private PreferenceStore webAccessPref;
    private Color textBackColor;

    public HttpAccessPreferencePage() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void init(IWorkbench workbench) {
        this.webAccessPref = new PreferenceStore(WEB_PREFERENCE);
        try {
            this.webAccessPref.load();
        }
        catch (IOException e1) {
            logger.info("HTTP Access preference IOException : " + e1.getMessage());
        }
    }

    protected Control createContents(Composite parent) {
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 4;
        Label label = new Label(composite, 0);
        label.setText(HTTP_HOST_LABEL);
        label.setLayoutData((Object)new GridData());
        this.httpHost = new Text(composite, 2048);
        this.httpHost.setText(this.webAccessPref.getString(HTTP_HOST_KEY));
        gridData = new GridData();
        gridData.widthHint = 150;
        this.httpHost.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(HTTP_PORT_LABEL);
        label.setLayoutData((Object)new GridData());
        this.httpPort = new Text(composite, 2048);
        this.httpPort.setText(this.webAccessPref.getString(HTTP_PORT_KEY));
        gridData = new GridData();
        gridData.widthHint = 50;
        this.httpPort.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(HTTP_CONTEXT_LABEL);
        label.setLayoutData((Object)new GridData());
        this.httpContext = new Text(composite, 2048);
        this.httpContext.setText(this.webAccessPref.getString(HTTP_CONTEXT_KEY));
        gridData = new GridData();
        gridData.widthHint = 150;
        this.httpContext.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(HTTP_URL_LABEL);
        label.setLayoutData((Object)new GridData());
        this.httpUrltext = new Text(composite, 2056);
        this.httpUrltext.setText(this.webAccessPref.getString(HTTP_URL_KEY));
        gridData = new GridData();
        gridData.widthHint = 300;
        this.httpUrltext.setLayoutData((Object)gridData);
        this.httpUrltext.setEditable(false);
        this.httpUrltext.setEnabled(false);
        this.httpUrltext.setBackground(this.textBackColor);
        return composite;
    }

    protected void performDefaults() {
        this.httpHost.setText(this.webAccessPref.getString(HTTP_HOST_KEY));
        this.httpPort.setText(this.webAccessPref.getString(HTTP_PORT_KEY));
        this.httpContext.setText(this.webAccessPref.getString(HTTP_CONTEXT_KEY));
        this.httpUrltext.setText(this.webAccessPref.getString(HTTP_URL_KEY));
    }

    public boolean performOk() {
        String workUrl = "http://" + this.httpHost.getText() + ":" + this.httpPort.getText() + "/" + this.httpContext.getText() + "/";
        this.httpUrltext.setText(workUrl);
        this.webAccessPref.setValue(HTTP_URL_KEY, this.httpUrltext.getText());
        this.webAccessPref.setValue(HTTP_HOST_KEY, this.httpHost.getText());
        this.webAccessPref.setValue(HTTP_PORT_KEY, this.httpPort.getText());
        this.webAccessPref.setValue(HTTP_CONTEXT_KEY, this.httpContext.getText());
        try {
            this.webAccessPref.save();
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        return super.performOk();
    }
}

