/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.OlsonTimeZone;
import com.ibm.icu.impl.ZoneInfoExt;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;

public final class ZoneMeta {
    private static final boolean ASSERT = false;
    private static Map canonicalMap = null;
    public static final String HOUR = "hourFormat";
    public static final String GMT = "gmtFormat";
    public static final String REGION_FORMAT = "regionFormat";
    public static final String FALLBACK_FORMAT = "fallbackFormat";
    public static final String ZONE_STRINGS = "zoneStrings";
    public static final String FORWARD_SLASH = "/";
    private static final String[] EMPTY = new String[0];
    private static final String kZONEINFO = "zoneinfo";
    private static final String kREGIONS = "Regions";
    private static final String kZONES = "Zones";
    private static final String kRULES = "Rules";
    private static final String kNAMES = "Names";
    private static final String kDEFAULT = "Default";
    private static final String kGMT_ID = "GMT";
    private static final String kCUSTOM_ID = "Custom";
    private static Enumeration idEnum = null;
    static int OLSON_ZONE_START = -1;
    static int OLSON_ZONE_COUNT = 0;
    static /* synthetic */ Class class$0;

    public static synchronized String[] getAvailableIDs(String country) {
        if (!ZoneMeta.getOlsonMeta()) {
            return EMPTY;
        }
        try {
            ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle regions = top.get(kREGIONS);
            ICUResourceBundle names = top.get(kNAMES);
            ICUResourceBundle temp = regions.get(country);
            int[] vector = temp.getIntVector();
            String[] ret = new String[vector.length];
            int i = 0;
            while (i < vector.length) {
                ret[i] = names.getString(vector[i]);
                ++i;
            }
            return ret;
        }
        catch (MissingResourceException missingResourceException) {
            return EMPTY;
        }
    }

    public static synchronized String[] getAvailableIDs() {
        if (!ZoneMeta.getOlsonMeta()) {
            return EMPTY;
        }
        try {
            ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle names = top.get(kNAMES);
            return names.getStringArray();
        }
        catch (MissingResourceException missingResourceException) {
            return EMPTY;
        }
    }

    public static synchronized String[] getAvailableIDs(int offset) {
        Vector<String> vector = new Vector<String>();
        int i = 0;
        while (i < OLSON_ZONE_COUNT) {
            com.ibm.icu.util.TimeZone z;
            String unistr = ZoneMeta.getID(i);
            if (unistr != null && (z = com.ibm.icu.util.TimeZone.getTimeZone(unistr)) != null && z.getID().equals(unistr) && z.getRawOffset() == offset) {
                vector.add(unistr);
            }
            ++i;
        }
        if (!vector.isEmpty()) {
            String[] strings = new String[vector.size()];
            return vector.toArray(strings);
        }
        return EMPTY;
    }

    private static String getID(int i) {
        try {
            ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle names = top.get(kNAMES);
            return names.getString(i);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static synchronized int countEquivalentIDs(String id) {
        ICUResourceBundle res = ZoneMeta.openOlsonResource(id);
        int size = res.getSize();
        if (size == 4 || size == 6) {
            ICUResourceBundle r = res.get(size - 1);
            int[] v = r.getIntVector();
            return v.length;
        }
        return 0;
    }

    public static synchronized String getEquivalentID(String id, int index) {
        String result = "";
        ICUResourceBundle res = ZoneMeta.openOlsonResource(id);
        int zone = -1;
        int size = res.getSize();
        if (size == 4 || size == 6) {
            ICUResourceBundle r = res.get(size - 1);
            int[] v = r.getIntVector();
            if (index >= 0 && index < size && ZoneMeta.getOlsonMeta()) {
                zone = v[index];
            }
        }
        if (zone >= 0) {
            ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle ares = top.get(kNAMES);
            result = ares.getString(zone);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getCanonicalInfo(String id) {
        if (canonicalMap != null) return (String[])canonicalMap.get(id);
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        int i = 0;
        while (i < ZoneInfoExt.CLDR_INFO.length) {
            String[] clist = ZoneInfoExt.CLDR_INFO[i];
            String c = clist[0];
            m.put(c, clist);
            int j = 3;
            while (j < clist.length) {
                m.put(clist[j], clist);
                ++j;
            }
            ++i;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.impl.ZoneMeta");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            canonicalMap = m;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return (String[])canonicalMap.get(id);
        }
    }

    public static String getCanonicalID(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[0];
        }
        return tzid;
    }

    public static String getCanonicalCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null) {
            return info[1];
        }
        return null;
    }

    public static String getSingleCountry(String tzid) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info != null && info[2] != null) {
            return info[1];
        }
        return null;
    }

    public static String displayFallback(String tzid, String city, ULocale locale) {
        String[] info = ZoneMeta.getCanonicalInfo(tzid);
        if (info == null) {
            return null;
        }
        String country_code = info[1];
        if (country_code == null) {
            return null;
        }
        String country = null;
        if (country_code != null) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", locale);
            if (rb.getLoadingStatus() != 2 && rb.getLoadingStatus() != 3) {
                country = ULocale.getDisplayCountry("xx_" + country_code, locale);
            }
            if (country == null || country.length() == 0) {
                country = country_code;
            }
        }
        if (info[2] != null) {
            return ZoneMeta.displayRegion(country, locale);
        }
        if (city == null) {
            city = tzid.substring(tzid.lastIndexOf(47) + 1).replace('_', ' ');
        }
        String flbPat = ZoneMeta.getTZLocalizationInfo(locale, FALLBACK_FORMAT);
        MessageFormat mf = new MessageFormat(flbPat);
        return mf.format(new Object[]{city, country});
    }

    public static String displayRegion(String cityOrCountry, ULocale locale) {
        String regPat = ZoneMeta.getTZLocalizationInfo(locale, REGION_FORMAT);
        MessageFormat mf = new MessageFormat(regPat);
        return mf.format(new Object[]{cityOrCountry});
    }

    public static String displayGMT(long value, ULocale locale) {
        String msgpat = ZoneMeta.getTZLocalizationInfo(locale, GMT);
        String dtepat = ZoneMeta.getTZLocalizationInfo(locale, HOUR);
        int n = dtepat.indexOf(59);
        if (n != -1) {
            if (value < 0L) {
                value = -value;
                dtepat = dtepat.substring(n + 1);
            } else {
                dtepat = dtepat.substring(0, n);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dtepat, locale);
        sdf.setTimeZone(com.ibm.icu.util.TimeZone.getTimeZone(kGMT_ID));
        String res = sdf.format(new Long(value));
        MessageFormat mf = new MessageFormat(msgpat);
        res = mf.format(new Object[]{res});
        return res;
    }

    public static String getTZLocalizationInfo(ULocale locale, String format) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance(locale);
        return bundle.getStringWithFallback("zoneStrings/" + format);
    }

    private static Set getValidIDs() {
        TreeSet<String> valid = new TreeSet<String>();
        valid.addAll(Arrays.asList(TimeZone.getAvailableIDs()));
        return valid;
    }

    public static ICUResourceBundle openOlsonResource(String id) {
        if (!ZoneMeta.getOlsonMeta()) {
            return null;
        }
        ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        ICUResourceBundle res = ZoneMeta.getZoneByName(top, id);
        if (res.getSize() <= 1 && ZoneMeta.getOlsonMeta(top)) {
            int deref = res.getInt() + 0;
            ICUResourceBundle ares = top.get(kZONES);
            res = ares.get(deref);
        }
        return res;
    }

    private static ICUResourceBundle getZoneByName(ICUResourceBundle top, String id) {
        ICUResourceBundle tmp = top.get(kNAMES);
        int idx = ZoneMeta.findInStringArray(tmp, id);
        if (idx == -1) {
            throw new MissingResourceException(kNAMES, tmp.resPath, id);
        }
        tmp = top.get(kZONES);
        tmp = tmp.get(idx);
        return tmp;
    }

    private static int findInStringArray(ICUResourceBundle array, String id) {
        int mid;
        int start = 0;
        int limit = array.getSize();
        String u = null;
        int lastMid = Integer.MAX_VALUE;
        if (limit < 1) {
            return -1;
        }
        while (lastMid != (mid = (start + limit) / 2)) {
            lastMid = mid;
            u = array.getString(mid);
            if (u == null) break;
            int r = id.compareTo(u);
            if (r == 0) {
                return mid;
            }
            if (r < 0) {
                limit = mid;
                continue;
            }
            start = mid;
        }
        return -1;
    }

    private static boolean getOlsonMeta(ICUResourceBundle top) {
        if (OLSON_ZONE_START < 0) {
            ICUResourceBundle res = top.get(kZONES);
            OLSON_ZONE_COUNT = res.getSize();
            OLSON_ZONE_START = 0;
        }
        return OLSON_ZONE_START >= 0;
    }

    private static boolean getOlsonMeta() {
        ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        if (OLSON_ZONE_START < 0) {
            ZoneMeta.getOlsonMeta(top);
        }
        return OLSON_ZONE_START >= 0;
    }

    public static com.ibm.icu.util.TimeZone getSystemTimeZone(String id) {
        try {
            ICUResourceBundle top = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt34b", kZONEINFO, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            ICUResourceBundle res = ZoneMeta.openOlsonResource(id);
            OlsonTimeZone z = new OlsonTimeZone(top, res);
            ((com.ibm.icu.util.TimeZone)z).setID(id);
            return z;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static com.ibm.icu.util.TimeZone getGMT() {
        SimpleTimeZone z = new SimpleTimeZone(0, kGMT_ID);
        ((com.ibm.icu.util.TimeZone)z).setID(kGMT_ID);
        return z;
    }

    public static com.ibm.icu.util.TimeZone getCustomTimeZone(String id) {
        NumberFormat numberFormat = null;
        String idUppercase = id.toUpperCase();
        if (id.length() > kGMT_ID.length() && idUppercase.startsWith(kGMT_ID)) {
            ParsePosition pos = new ParsePosition(kGMT_ID.length());
            boolean negative = false;
            if (id.charAt(pos.getIndex()) == '-') {
                negative = true;
            } else if (id.charAt(pos.getIndex()) != '+') {
                return null;
            }
            pos.setIndex(pos.getIndex() + 1);
            numberFormat = NumberFormat.getInstance();
            numberFormat.setParseIntegerOnly(true);
            int start = pos.getIndex();
            Number n = numberFormat.parse(id, pos);
            if (pos.getIndex() == start) {
                return null;
            }
            long offset = n.longValue();
            if (pos.getIndex() < id.length() && id.charAt(pos.getIndex()) == ':') {
                offset *= 60L;
                pos.setIndex(pos.getIndex() + 1);
                int oldPos = pos.getIndex();
                n = numberFormat.parse(id, pos);
                if (pos.getIndex() == oldPos) {
                    return null;
                }
                offset += n.longValue();
            } else {
                offset = offset < 30L && pos.getIndex() - start <= 2 ? (offset *= 60L) : offset % 100L + offset / 100L * 60L;
            }
            if (negative) {
                offset = -offset;
            }
            SimpleTimeZone z = new SimpleTimeZone((int)(offset * 60000L), kCUSTOM_ID);
            ((com.ibm.icu.util.TimeZone)z).setID(kCUSTOM_ID);
            return z;
        }
        return null;
    }
}

