/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.application;

import java.util.logging.Logger;

import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.nodemaneger.NodeManagerPerspective;
import netjfwatcher.engine.view.EngineManagerPerspective;
import netjfwatcher.snmpagent.AgentPerspective;
import netjfwatcher.snmpmanager.SnmpManagerPerspective;
import netjfwatcher.socketclient.NetworkClientPerspective;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * p[XyNeBuɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderPerspective {

	private IAction netwaokAction = new ActionNetworkWatch();

	private IAction snmpBrowserAction = new ActionSNMPBrowser();

	private IAction snmpAgentAction = new ActionSNMPAgent();

	private IAction nodeManagerAgentAction = new ActionNodeManager();

	private IAction socketClientAction = new ActionSocketClient();

	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	public ActionBuilderPerspective() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction getActionNetworkWatch() {
		return netwaokAction;
	}

	public IAction getActionSnmpBrowser() {
		return snmpBrowserAction;
	}

	public IAction getActionSnmpAgent() {
		return snmpAgentAction;
	}

	public IAction getActionNodeManager() {
		return nodeManagerAgentAction;
	}

	public IAction getActionSocketClient() {
		return socketClientAction;
	}

	/**
	 * ANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractPerspectiveAction extends Action {
		public final void run() {
			doTask();
		}

		protected abstract void doTask();
	}

	protected class ActionNetworkWatch extends AbstractPerspectiveAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/engine.gif"));
		}

		public String getText() {
			return "Network Watcher Start";
		}

		public String getToolTipText() {
			return "Network Watcher Start";
		}

		protected void doTask() {

			IWorkbench workbench = PlatformUI.getWorkbench();
			try {
				workbench.showPerspective(EngineManagerPerspective.ID,
						workbench.getActiveWorkbenchWindow());
				workbench.showPerspective(NodeManagerPerspective.ID, workbench
						.getActiveWorkbenchWindow());
				
				ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();
				actionBuilderEngine.getActionStartEngine().run();
			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Abort system start.");
				logger.warning("Abort system start. " + e.getMessage());
				shell.dispose();
			}

		}
	}

	/**
	 * SNMPuEU p[XyNeBuI[vANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public class ActionSNMPBrowser extends AbstractPerspectiveAction {

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/SnmpM.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "SNMP Browser open";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "SNMP Browser open";
		}

		protected void doTask() {
			IWorkbench workbench = PlatformUI.getWorkbench();
			try {
				workbench.openWorkbenchWindow(SnmpManagerPerspective.ID,
						null);

			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error",
						"Abort SNMP Browser start.");
				logger.warning("Abort SNMP Browser start. " + e.getMessage());
				shell.dispose();
			}

		}

	}

	/**
	 * SNMPG[WFg p[XyNeBuI[vANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public class ActionSNMPAgent extends AbstractPerspectiveAction {

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/SnmpA.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "SNMP Agent open";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "SNMP Agent open";
		}

		protected void doTask() {

			IWorkbench workbench = PlatformUI.getWorkbench();
			try {
				workbench.openWorkbenchWindow(AgentPerspective.ID, null);

			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error",
						"Abort SNMP Browser start.");
				logger.warning("Abort SNMP Browser start. " + e.getMessage());
				shell.dispose();
			}

		}

	}

	protected class ActionNodeManager extends AbstractPerspectiveAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/manager.gif"));
		}

		public String getText() {
			return "Show Node manger";
		}

		public String getToolTipText() {
			return "Show Node manger";
		}

		protected void doTask() {

			IWorkbench workbench = PlatformUI.getWorkbench();
			try {
				workbench.showPerspective(NodeManagerPerspective.ID, workbench
						.getActiveWorkbenchWindow());
			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error",
						"Abort show Node Manager.");
				logger.warning("Abort show Node Manager. " + e.getMessage());
				shell.dispose();
			}

		}
	}

	protected class ActionSocketClient extends AbstractPerspectiveAction {

		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/monitor_obj.gif"));
		}

		public String getText() {
			return "Show Node manger at Socket client";
		}

		public String getToolTipText() {
			return "Show Node manger at Socket client";
		}

		protected void doTask() {

			IWorkbench workbench = PlatformUI.getWorkbench();
			try {
				workbench.showPerspective(NetworkClientPerspective.ID,
						workbench.getActiveWorkbenchWindow());
			} catch (Exception e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error",
						"Abort show socket client.");
				logger.warning("Abort show socket client. " + e.getMessage());
				shell.dispose();
			}

		}
	}
}
