/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model.apachederby;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Logger;

import org.apache.derby.drda.NetworkServerControl;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.PlatformUI;


/**
 * Apache Derby Embedded̑s\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ApacheDerbyEmbeddedDerby {
    /* Apache Derby Embedded NetworkServerControlCX^X */
    private static NetworkServerControl embeddedDerbyServer = null;

    /* Apache Embedded start try count */
    private static final int TRY_COUNT = 4;

    /* Apache Embedded start try error count */
    private static final int ERROR_COUNT = 3;

    /* Apache Embedded start try period(ms) */
    private static final int TRY_PERIOD = 5000;

    /* MO */
    private static Logger logger;

    /* Apache Derby EmbeddedDerbyғ */
    private boolean isEmbeddedDerby = false;

    /* Apache Derby EmbeddedNstO */
    private boolean isAbort;

    /* Apache Derby EmbeddedNs̃bZ[W */
    private String abortMessage = "";

    /**
     * Apache Derby Embedded̑s\bhNX
     * CX^X𐶐܂B
     */
    private ApacheDerbyEmbeddedDerby() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Apache Derby EmbeddedJn܂B
     *
     * @throws Exception Apach Derby EmbeddedJnɎsꍇ
     */
    public void startEmbeddedDerby() throws Exception {
        if (isEmbeddedDerby) {
            throw new ApacheDerbyException("Already start EmbeddedDerby");
        }

        logger.info("Starting Embedded Apache Derby");

        isAbort = false;

        /* Start network server using the property
         * and then wait for the server to start by testing a connection
         */
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    try {
                        startWithProperty();
                        waitForStart();
                    } catch (Exception e) {
                        abortMessage =
                            "Abort start Embedded Derby " + e.getMessage();
                        logger.warning(
                            "Abort start Embedded Derby " + e.getMessage());
                        isAbort = true;
                    }
                }
            });

        if (isAbort) {
            throw new Exception(abortMessage);
        }
    }

    /**
     * Apache Derby Embedded~܂
     *
     * @throws SQLException f[^x[XANZXňُ킪ꍇ
     */
    public void stopEmbeddedDerby() throws SQLException {
        try {
            isEmbeddedDerby = false;
            logger.info("shutdown Embedded Derby");
            // shutdown Derby Network Server
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        } catch (SQLException se) {
            /*logger.warning("Abort shutdown Embedded Derby "
            + se.getMessage());
            */

            // throw se;
            // nothing
        }
    }

    /**
     * Start Derby Network Server using the property
     * derby.drda.startNetworkServer. This property can be set as a system property or
     * or by setting in derby.properties file.
     * Setting this property to true , starts the Network Server when
     * Derby boots up.
     * The port at which the Derby Network Server listens to can be changed
     * by setting the derby.drda.portNumber property. By default, the server starts
     * at port 1527
     * Server output goes to derby.log
     */
    private void startWithProperty() throws Exception {
        logger.info("derby.drda.startNetworkServer set true");
        System.setProperty(
            ApacheDerbyPreference.START_NETWORK_SERVER_PROPERTY, "true");
        logger.info(
            ApacheDerbyPreference.START_NETWORK_SERVER_PROPERTY
            + System.getProperty(
                ApacheDerbyPreference.START_NETWORK_SERVER_PROPERTY));

        try {
            /* Booting derby */
            Class.forName(ApacheDerbyPreference.EMBEDDED_DRIVER).newInstance();
            isEmbeddedDerby = true;
        } catch (InstantiationException e) {
            throw new ApacheDerbyException(
                "InstantiationException " + e.getMessage());
        } catch (IllegalAccessException e) {
            throw new ApacheDerbyException(
                "IllegalAccessException " + e.getMessage());
        } catch (ClassNotFoundException e) {
            throw new ApacheDerbyException(
                "ClassNotFoundException " + e.getMessage());
        }
    }

    /**
     * Tries to check if the Network Server is up and running by
     * calling ping If successful, then it returns else tries
     * for 50 seconds before giving up and throwing an exception.
     * @throws Exception when there is a problem with testing
     * if the Network Server is up and running
     */
    private void waitForStart() throws Exception {
        /* Server instance for testing connection */
        logger.info(
            "Testing if Network(Embedded Derby) Server is up and running!");

        /*
         * Use NetworkServerControl.ping() to wait for
         * NetworkServer to come up.  We could have used
         * NetworkServerControl to start the server but
         * the property is easier.
             */
        embeddedDerbyServer = new NetworkServerControl();

        for (int i = 0; i < TRY_COUNT; i++) {
            try {
                Thread.sleep(TRY_PERIOD);
                embeddedDerbyServer.ping();
            } catch (Exception e) {
                logger.info("Try #" + i + " " + e.toString());

                if (i >= ERROR_COUNT) {
                    logger.warning(
                        "Giving up trying to connect to Network Server!");
                    throw e;
                }
            }
        }

        logger.info("Derby Network(Embedded Derby) Server now running");
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ApacheDerbyEmbeddedDerby getInstance() {
        return SingletonResource.RESOURCE;
    }

    /*
     *  (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();
        stopEmbeddedDerby();
    }

    /**
     * Apache Derby EmbeddedDerbyғ󋵂Ԃ܂B
     *
     * @return isEmbeddedDerby Apache Derby EmbeddedDerbyғ
     */
    public boolean isEmbeddedDerby() {
        return isEmbeddedDerby;
    }

    /**
     * Apache Derby EmbeddedDerbyғ󋵂Zbg܂B
     *
     * @param isEmbeddedDerby Apache Derby EmbeddedDerbyғ
     */
    public void setEmbeddedDerby(boolean isEmbeddedDerby) {
        this.isEmbeddedDerby = isEmbeddedDerby;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ApacheDerbyEmbeddedDerby RESOURCE =
            new ApacheDerbyEmbeddedDerby();
    }
}
