/*
 * Created on 2003/08/25
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * m[hĎe[u猟ɍvm[hԂ
 * \bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SearchNoderegisterInfo {
    /* Logging */
    private Logger logger = null;

    /**
     * m[hĎe[u猟ɍvm[hԂ
     * \bhNXCX^X𐶐܂B
     *
     */
    public SearchNoderegisterInfo() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hĎe[u猟ɍvm[hԂ܂B
     *
     * @param columName Ώۂ̃J
     * @param whrereName Ώۂ̃Jɍv镶
     * @return nodeWatchInfoList Ɉvm[hĎ
     * ̃Xg
     */
    public ArrayList searchInfo(
        final String columName, final String whrereName) {
        if (!DatabaseControl.getInstance().isDatabaseStart()) {
            return null;
        }

        // SQL񐶐
        String sql =
            "SELECT * FROM " + DBTableNodeRegister.NODE_REGISTER_TABLE
            + " where " + columName + " = '" + whrereName + "'";

        ArrayList<NodeWatchInfo> nodeWatchInfoList = new ArrayList<NodeWatchInfo>();

        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;

        try {
            connection = databaseAccess.getConnection();
            statement = connection.createStatement();

            rs = statement.executeQuery(sql);

            while (rs.next()) {
                NodeWatchInfo nodewatchinfo = new NodeWatchInfo();
                nodewatchinfo.setNodename(
                    rs.getString(DBTableNodeRegister.NODENAME));
                nodewatchinfo.setGroup(
                    rs.getString(DBTableNodeRegister.NODEGROUP));
                nodewatchinfo.setIpaddress(
                    rs.getString(DBTableNodeRegister.IPADDRESS));
                nodewatchinfo.setNodeKind(
                        rs.getString(DBTableNodeRegister.NODEKIND));
                nodewatchinfo.setPingPeriod(
                    rs.getString(DBTableNodeRegister.PING_PERIOD));
                nodewatchinfo.setPingThreshold(
                    rs.getString(DBTableNodeRegister.PING_THRESHOLD));
                nodewatchinfo.setSnmpPeriod(
                    rs.getString(DBTableNodeRegister.SNMP_PERIOD));
                nodewatchinfo.setSnmpLevel(
                    rs.getString(DBTableNodeRegister.SNMP_LEVEL));
                nodewatchinfo.setSnmpROCommunity(
                    rs.getString(DBTableNodeRegister.SNMP_ROCOMMUNITY));

                nodeWatchInfoList.add(nodewatchinfo);
            }
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (statement != null) {
                try {
                    statement.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                statement = null;
            }

            if (connection != null) {
                if (databaseAccess != null) {
                    databaseAccess.releaseConnection(connection);
                    connection = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        databaseAccess);
                }
            }
        }

        return nodeWatchInfoList;
    }
}
