/*
 * Created on 2006/10/01
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.calendar;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.common.view.CalendarComposite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

/**
 * J_[ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CalendarView extends ViewPart {

	/* eLXg */
	private static final int TEXT_WIDTH = 80;

	private static final int HORIZONTALSPAN6 = 6;
	private static final int HORIZONTALSPAN3 = 3;
	/* MO */
	private static Logger logger;

	private String startDateString;

	private String endDateString;

	private int limit;

	private Button setButton;

	private Button resetButton;

	/* Filter limitl */
	private Text limitText;

	/* Filter JnN */
	private Text alarmStartYearText;

	/* Filter Jn */
	private Text alarmStartMonthText;

	/* Filter Jn */
	private Text alarmStartDateText;

	/* Filter IN */
	private Text alarmEndYearText;

	/* Filter I */
	private Text alarmEndMonthText;

	/* Filter I */
	private Text alarmEndDateText;

	private Combo startHourCombo;

	private Combo startMinuteCombo;

	private Combo endHourCombo;

	private Combo endMinuteCombo;

	private DateFormat dateformat;

	private CalendarComposite calendarComposite;

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * Calendar Composite𐶐ViewɃZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite composite0 = new Composite(parent, SWT.LEFT);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite1 = new Composite(composite0, SWT.LEFT);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData());

		setButton = new Button(composite1, SWT.NONE);
		setButton.setText(" Set ");
		setButton.setLayoutData(new GridData());

		resetButton = new Button(composite1, SWT.NONE);
		resetButton.setText("Reset");
		resetButton.setLayoutData(new GridData());
		Label label;

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		gridData = new GridData();

		label = new Label(composite1, SWT.NONE);
		label.setText("Limit");
		label.setLayoutData(new GridData());

		limitText = new Text(composite1, SWT.BORDER | SWT.RIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		limitText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		GridLayout gridLayout2 = new GridLayout(1, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		calendarComposite = new CalendarComposite();
		calendarComposite.setYearText(alarmStartYearText);
		calendarComposite.setMonthText(alarmStartMonthText);
		calendarComposite.setDateText(alarmStartDateText);

		calendarComposite.createCalendarView(composite2);

		GridLayout gridLayout3 = new GridLayout(9, false);
		Composite composite3 = new Composite(composite0, SWT.NONE);
		composite3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite3.setLayout(gridLayout3);

		Button startDateRadio = new Button(composite3, SWT.RADIO);
		startDateRadio.setText("Start date");

		startDateRadio.setSelection(true);
		GridData startGridData = new GridData();
		startGridData.horizontalSpan = HORIZONTALSPAN3;
		startGridData.verticalSpan = 1;
		startDateRadio.setLayoutData(startGridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTALSPAN6;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmStartYearText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		alarmStartYearText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmStartMonthText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmStartMonthText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmStartDateText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmStartDateText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		startHourCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		startHourCombo.setLayoutData(gridData);
		setHourCombo(startHourCombo);
		startHourCombo.select(0);

		label = new Label(composite3, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		startMinuteCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		startMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(startMinuteCombo);
		startMinuteCombo.select(0);

		Button endDateRadio = new Button(composite3, SWT.RADIO);
		endDateRadio.setText("End date");

		endDateRadio.setSelection(false);
		GridData endGridData = new GridData();
		endGridData.horizontalSpan = HORIZONTALSPAN3;
		endGridData.verticalSpan = 1;
		endDateRadio.setLayoutData(endGridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTALSPAN6;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmEndYearText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		alarmEndYearText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmEndMonthText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmEndMonthText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmEndDateText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		alarmEndDateText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		endHourCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		endHourCombo.setLayoutData(gridData);
		setHourCombo(endHourCombo);
		endHourCombo.select(0);

		label = new Label(composite3, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		endMinuteCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		endMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(endMinuteCombo);
		endMinuteCombo.select(0);

		calendarComposite.setYearText(alarmStartYearText);
		calendarComposite.setMonthText(alarmStartMonthText);
		calendarComposite.setDateText(alarmStartDateText);

		dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		/*
		 * FilterLԓ̊JnRdio{^IXi[
		 */
		startDateRadio.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				calendarComposite.setYearText(alarmStartYearText);
				calendarComposite.setMonthText(alarmStartMonthText);
				calendarComposite.setDateText(alarmStartDateText);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * FilterLԓ̏IRdio{^IXi[
		 */
		endDateRadio.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				calendarComposite.setYearText(alarmEndYearText);
				calendarComposite.setMonthText(alarmEndMonthText);
				calendarComposite.setDateText(alarmEndDateText);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		setButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				setButton.setEnabled(false);

				try {
					String limitString = limitText.getText();
					limit = Integer.parseInt(limitString);

					createDataInfo();
					DataFilterInfo.getInstance().setStartDateValue(
							startDateString);
					DataFilterInfo.getInstance().setEndDateValue(endDateString);
					DataFilterInfo.getInstance().setLimit(limit);

					Date workDate = Calendar.getInstance().getTime();
					if (startDateString != null && !startDateString.equals("")) {
						workDate.setTime(Long.parseLong(startDateString));
						DataFilterInfo.getInstance().setStartDate(
								dateformat.format(workDate));

					}
					if (endDateString != null && !endDateString.equals("")) {
						workDate.setTime(Long.parseLong(endDateString));
						DataFilterInfo.getInstance().setEndDate(
								dateformat.format(workDate));
					}

				} catch (NumberFormatException e) {

				} finally {
					setButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		resetButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				resetButton.setEnabled(false);

				try {
					startDateString = null;
					endDateString = null;
					limit = 0;
					limitText.setText("0");
					DataFilterInfo.getInstance().setStartDateValue(null);
					DataFilterInfo.getInstance().setEndDateValue(null);
					DataFilterInfo.getInstance().setLimit(limit);
					alarmStartYearText.setText("");
					alarmStartMonthText.setText("");
					alarmStartDateText.setText("");
					alarmEndYearText.setText("");
					alarmEndMonthText.setText("");
					alarmEndDateText.setText("");

					startHourCombo.select(0);
					startMinuteCombo.select(0);
					endHourCombo.select(0);
					endMinuteCombo.select(0);
				} finally {
					resetButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		setCalendarInfo();
	}

	/*
	 * Hour Combo Boxݒ肵܂B
	 * 
	 * @param combo Hour Combo Box
	 */
	private void setHourCombo(Combo combo) {
		for (int i = 0; i < 24; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * Minute Combo Boxݒ肵܂B
	 * 
	 * @param combo Minute Combo Box
	 */
	private void setMinuteCombo(Combo combo) {
		for (int i = 0; i < 60; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	private void setCalendarInfo() {

		limitText.setText(Integer.toString(DataFilterInfo.getInstance()
				.getLimit()));
		/*
		 * LԃZbg
		 */
		String startDateWorkString = "";
		String endDateWorkString = "";
		if (DataFilterInfo.getInstance().getStartDateValue() != null) {
			startDateWorkString = DataFilterInfo.getInstance()
					.getStartDateValue();
		} else {
			return;
		}
		if (DataFilterInfo.getInstance().getEndDateValue() != null) {
			endDateWorkString = DataFilterInfo.getInstance().getEndDateValue();
		} else {
			return;
		}

		try {
			long startDateLong = Long.parseLong(startDateWorkString);

			Date startDate = new Date(startDateLong);

			Calendar cal = Calendar.getInstance();
			cal.setTime(startDate);

			alarmStartYearText
					.setText(Integer.toString(cal.get(Calendar.YEAR)));
			alarmStartMonthText.setText(Integer.toString((cal
					.get(Calendar.MONTH) + 1)));
			alarmStartDateText
					.setText(Integer.toString(cal.get(Calendar.DATE)));

			String work = Integer.toString(cal.get(Calendar.HOUR_OF_DAY));

			if (work.length() == 1) {
				work = "0" + work;
			}

			startHourCombo.setText(work);
			work = Integer.toString(cal.get(Calendar.MINUTE));

			if (work.length() == 1) {
				work = "0" + work;
			}

			startMinuteCombo.setText(work);
		} catch (NumberFormatException e) {
			// nothing
		}

		try {
			Date endDate = new Date(Long.parseLong(endDateWorkString));

			Calendar cal = Calendar.getInstance();
			cal.setTime(endDate);

			alarmEndYearText.setText(Integer.toString(cal.get(Calendar.YEAR)));
			alarmEndMonthText.setText(Integer
					.toString((cal.get(Calendar.MONTH) + 1)));
			alarmEndDateText.setText(Integer.toString(cal.get(Calendar.DATE)));

			String work = Integer.toString(cal.get(Calendar.HOUR_OF_DAY));

			if (work.length() == 1) {
				work = "0" + work;
			}

			endHourCombo.setText(work);
			work = Integer.toString(cal.get(Calendar.MINUTE));

			if (work.length() == 1) {
				work = "0" + work;
			}

			endMinuteCombo.setText(work);
		} catch (NumberFormatException e) {
			// nothing
		}

	}

	private void createDataInfo() {
		int year = 0;
		int month = 0;
		int date = 0;
		int hour = 0;
		int minute = 0;

		if ((alarmStartYearText.getText() != null)
				&& !alarmStartYearText.getText().equals("")) {
			String startYearString = alarmStartYearText.getText();
			String startMonthString = alarmStartMonthText.getText();
			String startDateWorkString = alarmStartDateText.getText();

			String startHourString = startHourCombo.getText();
			String startMinuteString = startMinuteCombo.getText();

			try {
				year = Integer.parseInt(startYearString);
				month = Integer.parseInt(startMonthString);
				date = Integer.parseInt(startDateWorkString);
				hour = Integer.parseInt(startHourString);
				minute = Integer.parseInt(startMinuteString);

				Calendar cal = Calendar.getInstance();
				cal.set(year, month - 1, date, hour, minute);

				startDateString = Long.toString(cal.getTimeInMillis());

			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
		}

		if ((alarmEndYearText.getText() != null)
				&& !alarmEndYearText.getText().equals("")) {
			String endYearString = alarmEndYearText.getText();
			String endMonthString = alarmEndMonthText.getText();
			String endDateWorkString = alarmEndDateText.getText();

			String endHourString = endHourCombo.getText();
			String endMinuteString = endMinuteCombo.getText();

			try {
				year = Integer.parseInt(endYearString);
				month = Integer.parseInt(endMonthString);
				date = Integer.parseInt(endDateWorkString);
				hour = Integer.parseInt(endHourString);
				minute = Integer.parseInt(endMinuteString);

				Calendar cal = Calendar.getInstance();
				cal.set(year, month - 1, date, hour, minute);

				endDateString = Long.toString(cal.getTimeInMillis());

			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
		}

	}
}
