/*
 * Created on 2004/12/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * vC^tF[XMIB̎̕ύXsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandInterfaceMib extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * vC^tF[XMIB̎̕ύXs܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        ArrayList list = null;

        DBTableInterfaceMIB interfaceMibDBtable =
            DBTableInterfaceMIB.getInstance();

        try {
            list =
                interfaceMibDBtable.findSNMPInterfaces(
                    com.getIpaddress(), true);
        } catch (SQLException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        sendResponse(list, ois, oos);
    }
}
