/*
 * Created on 2004/06/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.mail.MailSend;
import netjfwatcher.engine.mail.MailSendException;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MailSendTestInformation;


/**
 * MailMeXgsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandMailSendTest extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * MailMeXgs܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        MailSendTestInformation mailSendtestInfo = com.getMailSendtestInfo();

        /*
        System.out.println("SMTP Host : " + mailSendtestInfo.getSmtpHost());
        System.out.println("From : " + mailSendtestInfo.getMailFrom());
        System.out.println("To : " + mailSendtestInfo.getMailTo());
        System.out.println("Sunbject : " + mailSendtestInfo.getMailSubject());
        System.out.println("Body : " + mailSendtestInfo.getMailBody());
        */
        String mailSendResult = "Mail Send Test OK";

        try {
            /* MailMs */
            MailSend.getInstance().sendMail(
                mailSendtestInfo.getSmtpHost(), mailSendtestInfo.getMailFrom(),
                mailSendtestInfo.getMailTo(), mailSendtestInfo.getMailSubject(),
                mailSendtestInfo.getMailBody());
        } catch (MailSendException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            mailSendResult = e1.getMessage();
        }

        sendResponse(mailSendResult, ois, oos);
    }
}
