/*
 * Created on 2004/07/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.snmpmanager.statistics.StatisticsMibDBRegister;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * vMIB̎撆OID폜郁\bh܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandStatisticsMibDelete extends TemplateCommandImpl {
    /* MO */
    private static Logger logger;

    /**
     * vMIB̎撆OID폜܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        logger.info(
            "Statistics MIB Delete : " + "IP=" + com.getIpaddress() + " OID="
            + com.getMibInfo().getRequestMibOid());

        // Database e[uXV
        StatisticsMibDBRegister mibStatisGet =
            new StatisticsMibDBRegister(
                com.getIpaddress(), com.getMibInfo().getVersion(),
                com.getMibInfo().getRoCommunity());

        /*  */
        mibStatisGet.updateMibStatisticsSetDatabase(
            com.getMibInfo().getRequestMibOid(), "--", "--", "--");

        // ThreadXgL[̓o^폜
        ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(
            com.getIpaddress());

        // ThreadXgL[ɍēo^
        StatisticsMibInfo mibInfo =
            StatisticsMibInfo.getInstance(com.getIpaddress());
        mibInfo.removeOid(com.getMibInfo().getRequestMibOid());

        ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(
            com.getIpaddress(), mibInfo);

        /*  */
        sendResponse(CommandMappingTableResource.ACK_RESPONSE, ois, oos);
    }
}
