package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;


/**
 * DatabaseĎɊւANV`NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderDatabaseWatch extends Action {
    /* MO */
    private static Logger logger;

    /*
     * m[hViewō\\EditorPartEditorPart
     * JxɁAUEditorPartCloseĂOpen
     */
    private IEditorPart editorNodeConfigView;


    /* DatabaseĎr[\ANV */
    private IAction databaseWatchAction = new ActionDatabaseWatch();
    /* lbg[NoRDatabaseĎr[\ANV */
    private IAction databaseWatchActionSocket = new ActionDatabaseWatchSocket();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * DatabaseĎɊւANVNXCX^X
     * ܂B
     *
     */
    public ActionBuilderDatabaseWatch() {
        logger = Logger.getLogger(this.getClass().getName());
    }


    /**
     * DatabaseĎr[\ANVԂ܂B
     *
     * @return databaseWatchAction DatabaseĎr[\ANV
     */
    public IAction getActionDatabaseWatch() {
        return databaseWatchAction;
    }
    
    /**
     * lbg[NoRłDatabaseĎr[\ANVԂ܂B
     *
     * @return databaseWatchActionSocket lbg[NoRłDatabaseĎr[\ANV
     */
    public IAction getActionDatabaseWatchSocket() {
        return databaseWatchActionSocket;
    }
    
    /**
     * DatabaseĎr[ɊւANV`钊ۃNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractDatabaseAction extends Action {
        /**
         * ANVs܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANVs^XNłB
         *
         */
        protected abstract void doTask();
    }

    /**
     * DatabaseĎr[\sANVۃNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public abstract class AbstractActionDatabaseView extends AbstractDatabaseAction {
        protected NodeInformation nodeInfo;

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.DATABASE_WATCH_VIEW_IMAGE_FILE));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.DATABASE_WATCH_VIEW;
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.DATABASE_WATCH_VIEW_TOOL_TIP;
        }

        /**
         * DatabaseĎr[\^XNłB
         *
         */
        protected void doTask() {

        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }


    
    /**
     * DatabaseĎr[\ANVNXłB
     *
     */
    public class ActionDatabaseWatch extends AbstractActionDatabaseView {
        

        /**
         * DatabaseĎr[Editor partɕ\܂B
         *
         */
        protected void doTask() {

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";
            try {
                /*
                 * EditorI[v
                 */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                        		nodeName + " Database Watch Node View", nodeInfo, false),
                        		"netwatcher.database.view.EditorDatabaseWatcherConfigView");
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
    /**
     * lbg[NoRDatabaseĎr[\ANVNXłB
     *
     */
    public class ActionDatabaseWatchSocket extends ActionDatabaseWatch {

        /**
         * DatabaseĎr[Editor partɕ\܂B
         *
         */
        protected void doTask() {

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }
            
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";
            try {
                /*
                 * EditorI[v
                 */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                        		nodeName + " Database Watch Node View", nodeInfo, true),
                             "netwatcher.database.view.EditorDatabaseWatcherConfigView");
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
