/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmp;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisricsSet;
import netjfwatcher.engine.view.editorpart.snmp.EditorSnmpStatisticsInfo;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;


/**
 * SNMPvɊւANV`NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderSnmp extends Action {
    /* MO */
    private static Logger logger;

    /*
     * m[hViewō\\EditorPartEditorPart
     * JxɁAUEditorPartCloseĂOpen
     */
    private IEditorPart editorNodeConfigView;

    /* m[hSNMP(System MIByInterface MIB)\ANV */
    private IAction snmpInfoShowAction = new ActionShowNodeSnmpView();

    /* lbg[NoRł̃m[hSNMP(System MIByInterface MIB)\ANV */
    private IAction snmpInfoShowActionSocket =
        new ActionShowNodeSnmpViewSocket();

    /* m[hSNMPv̎ݒsANV */
    private IAction snmpStatisticsSetAction = new ActionSnmpStatisticsSet();

    /* lbg[NoRŃm[hSNMPv̎ݒsANV */
    private IAction snmpStatisticsSetActionSocket =
        new ActionSnmpStatisticsSetSocket();

    /* SNMPv\ANV */
    private IAction snmpStatisticsAction = new ActionSnmpStatistics();

    /* lbg[NoRSNMPv\ANV */
    private IAction snmpStatisticsActionSocket =
        new ActionSnmpStatisticsSocket();

    /* Printer m[hSNMP\ANV */
    private IAction snmpPrintAction = new ActionSnmpPrint();
    /* lbg[NoRPrinter m[hSNMP\ANV */
    private IAction snmpPrintActionSocket = new ActionSnmpPrintSocket();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * SnmpvɊւANVNXCX^X
     * ܂B
     *
     */
    public ActionBuilderSnmp() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hSNMP(System MIByInterface MIB)\ANVԂ܂B
     *
     * @return snmpInfoShowAction m[hSNMP(System MIByInterface MIB)
     * \ANV
     */
    public IAction getActionSnmpInfo() {
        return snmpInfoShowAction;
    }

    /**
     * lbg[NoRł̃m[hSNMP(System MIByInterface MIB)\
     * ANVԂ܂B
     *
     * @return snmpInfoShowActionSocket lbg[NoRł̃m[hSNMP
     * (System MIByInterface MIB)\ANV
     */
    public IAction getActionSnmpInfoSocket() {
        return snmpInfoShowActionSocket;
    }

    /**
     * m[hSNMPv̎ݒsANVԂ܂B
     *
     * @return snmpStatisticsSetAction m[hSNMPv̎ݒsANV
     */
    public IAction getActionSnmpStatisticsSet() {
        return snmpStatisticsSetAction;
    }

    /**
     * lbg[NoRł̃m[hSNMPv̎ݒsANVԂ܂B
     *
     * @return snmpStatisticsSetActionSocket lbg[NoRł̃m[hSNMPv
     * ̎ݒsANV
     */
    public IAction getActionSnmpStatisticsSetSocket() {
        return snmpStatisticsSetActionSocket;
    }

    /**
     * SNMPv\ANVԂ܂B
     *
     * @return snmpStatisticsAction SNMPv\ANV
     */
    public IAction getActionSnmpStatistics() {
        return snmpStatisticsAction;
    }

    /**
     * lbg[NoRłSNMPv\ANVԂ܂B
     *
     * @return snmpStatisticsActionSocket lbg[NoRłSNMPv
     * \ANV
     */
    public IAction getActionSnmpStatisticsSocket() {
        return snmpStatisticsActionSocket;
    }

    /**
     * Printerm[hSNMP\ANVԂ܂B
     *
     * @return snmpPrintAction Printerm[hSNMP\ANV
     */
    public IAction getActionPrintSnmp() {
        return snmpPrintAction;
    }
    
    /**
     * lbg[NoRłPrinterm[hSNMP\ANVԂ܂B
     *
     * @return snmpPrintAction lbg[NoRłPrinterm[hSNMP\ANV
     */
    public IAction getActionPrintSnmpSocket() {
        return snmpPrintActionSocket;
    }
    
    /**
     * SnmpvɊւANV`钊ۃNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractSnmpAction extends Action {
        /**
         * ANVs܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANVs^XNłB
         *
         */
        protected abstract void doTask();
    }

    /**
     * m[hSNMP View\sANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionShowNodeSnmpView extends AbstractSnmpAction {
        protected NodeInformation nodeInfo;

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.NODE_SNMP_VIEW_IMAGE_FILE));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.NODE_SNMP_VIEW;
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.NODE_SNMP_VIEW_TOOL_TIP;
        }

        /**
         * Node SNMP View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /* Tree\NodeZbg */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                activePage.openEditor(
                    new EditorInputNodeView(
                        nodeName + EditorNodeSnmp.TITLE_SUFFIX, nodeInfo, false),
                    EditorNodeSnmp.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * lbg[NoRł̃m[hSNMP View\sANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionShowNodeSnmpViewSocket extends AbstractSnmpAction {
        private NodeInformation nodeInfo;

        /**
         * ImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.NODE_SNMP_VIEW_IMAGE_FILE));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.NODE_SNMP_VIEW;
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.NODE_SNMP_VIEW_TOOL_TIP;
        }

        /**
         * Node SNMP View\^XNłB
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            /* Tree\NodeZbg */
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            try {
                activePage.openEditor(
                    new EditorInputNodeView(
                        nodeName + EditorNodeSnmp.TITLE_SUFFIX
                        + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(),
                        nodeInfo, true), EditorNodeSnmp.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * @param nodeInfo nodeInfo ݒB
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * SNMPv̎ݒsView\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionSnmpStatisticsSet extends AbstractSnmpAction {
        protected NodeInformation nodeInfo;

        /**
         * Snmpv̎ݒsView\ANV
         * ImageDescriptorԂ܂B
         *
         * @return Snmpv̎ݒsView\
         * ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(
                    MenuPreference.NODE_SNMP_STATISTICS_SET_IMAGE_FILE));
        }

        /**
         * AlarmXge[uXVANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.NODE_SNMP_STATISTICS_SET;
        }

        /**
         * SNMPv̎ݒsView\ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.NODE_SNMP_STATISTICS_SET_TOOL_TIP;
        }

        /**
         * SNMPv̎ݒs܂B
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }

            try {
                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                * EditorID̓uEŨNX
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            nodeName + EditorNodeSnmpStatisricsSet.TITLE_SUFFIX,
                            nodeInfo, false, ""),
                        EditorNodeSnmpStatisricsSet.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    /**
     * lbg[NoRSNMPv̎ݒsView\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionSnmpStatisticsSetSocket extends ActionSnmpStatisticsSet {
        /**
         * SNMPv̎ݒs܂B
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }

            try {
                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                * EditorID̓uEŨNX
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            nodeName + EditorNodeSnmpStatisricsSet.TITLE_SUFFIX
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true, ""),
                        EditorNodeSnmpStatisricsSet.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * SNMPv\ANVNXłB
     *
     */
    protected class ActionSnmpStatistics extends AbstractSnmpAction {
        /**
         * SNMPv\ANVImageDescriptorԂ܂B
         *
         * @return SNMPv\ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.SNMP_STATISTICS_INFO_IMAGE_FILE));
        }

        /**
         * SNMPv\ANṼeLXgԂ܂B
         *
         * @return SNMPv\ANṼeLXg
         */
        public String getText() {
            return MenuPreference.SNMP_STATISTICS_INFO;
        }

        /**
         * SNMPv\ANVToolTipTextԂ܂B
         *
         * @return SNMPv\ANVToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.SNMP_STATISTICS_INFO_TOOL_TIP;
        }

        /**
         * SNMPvEditor partɕ\܂B
         *
         */
        protected void doTask() {

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }

            try {
                /*
                 * EditorI[v
                 */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            EditorSnmpStatisticsInfo.TITLE_SUFFIX, false),
                        EditorSnmpStatisticsInfo.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * lbg[NoRSNMPv\ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    protected class ActionSnmpStatisticsSocket extends ActionSnmpStatistics {
        /**
         * SNMPvEditor partɕ\܂B
         *
         */
        protected void doTask() {
            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }

            try {
                /*
                 * EditorI[v
                 */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                            EditorSnmpStatisticsInfo.TITLE_SUFFIX
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), true),
                        EditorSnmpStatisticsInfo.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
    
    /**
     * SNMP Print\ANVNXłB
     *
     */
    public class ActionSnmpPrint extends ActionShowNodeSnmpView {
        /**
         * SNMP Print\ANVImageDescriptorԂ܂B
         *
         * @return SNMP Print\ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.PRINT_NODE_SNMP_VIEW_IMAGE_FILE));
        }

        /**
         * SNMP Print\ANṼeLXgԂ܂B
         *
         * @return SNMP Print\ANṼeLXg
         */
        public String getText() {
            return MenuPreference.PRINT_NODE_SNMP_VIEW;
        }

        /**
         * SNMP Print\ANVToolTipTextԂ܂B
         *
         * @return SNMP Print\ANVToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.PRINT_NODE_SNMP_VIEW_TOOL_TIP;
        }

        /**
         * SNMP PrintEditor partɕ\܂B
         *
         */
        protected void doTask() {

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";
            try {
                /*
                 * EditorI[v
                 */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                        		nodeName + " Printer Node View", nodeInfo, false),
                        		"netwatcher.printer.gui.editor.EditorPrinterNodeStatusView");
                            // EditorPrinterNodeStatusView.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
    /**
     * SNMP Print\ANVNXłB
     *
     */
    public class ActionSnmpPrintSocket extends ActionSnmpPrint {

        /**
         * SNMP PrintEditor partɕ\܂B
         *
         */
        protected void doTask() {

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            if (editorNodeConfigView != null) {
                activePage.closeEditor(editorNodeConfigView, false);
                editorNodeConfigView = null;
            }
            
            String nodeName =
                nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ")";
            try {
                /*
                 * EditorI[v
                 */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeView(
                        		nodeName + " Printer Node View", nodeInfo, true),
                             "netwatcher.printer.gui.editor.EditorPrinterNodeStatusView");
                            // EditorPrinterNodeStatusView.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
