/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeChart;
import netjfwatcher.engine.view.editorpart.ping.EditorNodePingChart;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * m[hMapł̃m[hIconIj[ŁAPingOt\I
 * ꍇ s郁\bhSelectionAdapterNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapMenuNodePingChart extends SelectionAdapter {
    /* MO */
    private static Logger logger;

    /* m[hĎ */
    private NodeInformation nodeInfo;

    /*
     * SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     */
    protected boolean isSocket;

    /* Ot\Xg */
    private ArrayList nameList;

    /**
     * m[hMapł̃m[hIconIj[ŁAPingOt\I
     * ꍇ s郁\bhSelectionAdapterNXCX^X
     * 𐶐܂B
     *
     * @param nodeInfo m[hĎ
     * @param isSocket SocketɂăT[of[^擾邩f[^x[X
     * 擾邩tO
     * @param nameList OtXg
     */
    public NodeMapMenuNodePingChart(
        NodeInformation nodeInfo, boolean isSocket, ArrayList nameList) {
        logger = Logger.getLogger(this.getClass().getName());
        this.nodeInfo = nodeInfo;
        this.isSocket = isSocket;
        this.nameList = nameList;
    }

    /**
     * PingOt\IłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        String title =
            nodeInfo.getNodename() + "(" + nodeInfo.getIpaddress() + ") "
            + "Ping " + AbstractEditorNodeChart.TITLE_SUFFIX;

        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            activePage.openEditor(
                new EditorInputNodeChart(title, nodeInfo, isSocket, nameList),
                EditorNodePingChart.class.getName());
        } catch (PartInitException ex) {
            logger.warning(ex.getMessage());
            ex.printStackTrace();
        }
    }
}
