/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * IɊĎPingĎm[h̃XgIɓǂŃL[Push
 * ThreadNXłB
 *
 *
 *
 *            ThreadListReadQ
 *           iXgf[^I
 *              L[Pushj
 *                 
 * |  | ---------+   +---------------+   QueueFor
 * |--|                            | |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +-----
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadListReadQueuePushPingControl implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * IPingĎm[h̃XgIɓǂŃL[Push
     * ThreadNXCX^X𐶐܂B
     *
     */
    public ThreadListReadQueuePushPingControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IPingĎm[h̃XgIɓǂŃL[Push܂B
     *
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // PingĎm[hXgǂݍ
            Map list = ListQueuePingControl.getInstance().getPingHashMap();

            for (it = list.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                NodeWatchInfo info = (NodeWatchInfo) list.get(key);

                if (info == null) {
                    continue;
                }

                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());

                if (nodeInfo == null) {
                    continue;
                }

                // Pingo
                count = Integer.parseInt(info.getCountPingPeriod());

                // logger.info("Ping Period : " + info.getCount_ping_period());
                // logger.info("Ping Period count down : " + count);
                if (count != 0) {
                    count--;
                    info.setCountPingPeriod(Integer.toString(count));

                    if (count == 0) {
                        // System.out.println("Count Zero : " + count);
                        // PingsL[Push
                        QueueForPing.getInstance().pushQue(info);

                        // PingJE^Zbg
                        info.setCountPingPeriod(info.getPingPeriod());
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
