/*
 * Created on 2004/10/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * ISMTPĎm[h̃XgIɓǂŃL[PushThread
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadListReadQueuePushSmtpControl implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * ISMTPĎm[h̃XgIɓǂŃL[PushThread
     * NXCX^X𐶐܂B
     *
     */
    public ThreadListReadQueuePushSmtpControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ISMTPĎm[h̃XgIɓǂŃL[Push܂B
     *
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // PingĎm[hXgǂݍ
            Map list = ListQueueSmtpControl.getInstance().getSmtpHashMap();

            for (it = list.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                NodeWatchInfo info = (NodeWatchInfo) list.get(key);

                if (info == null) {
                    continue;
                }

                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());

                if (nodeInfo == null) {
                    continue;
                }

                // SMTPo
                count = Integer.parseInt(info.getCountSmtpPeriod());

                if (count != 0) {
                    count--;
                    info.setCountSmtpPeriod(Integer.toString(count));

                    if (count == 0) {
                        // SMTPsL[Push
                        QueueForSmtp.getInstance().pushQue(info);

                        // SMTPJE^Zbg
                        info.setCountSmtpPeriod(info.getSmtpPeriod());
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
