/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.statistics;

import java.util.logging.Logger;

import netjfwatcher.database.access.model.DBTableBase;


/**
 * Snmpɂ鑗MINebgOID̎悷߂̃\bh`
 * NXłB
 *
 * ifInOctets 1.3.6.1.2.1.2.2.1.10 if:MINebg
 * ifOutOctets 1.3.6.1.2.1.2.2.1.16 if:MINebg
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadStatisticsMibGetControl {
    /* MO */
    private static Logger logger;

    /**
     * SNMPC^tF[XMIBMINebg̎悷
     * NXCX^X𐶐܂B
     *
     */
    public ThreadStatisticsMibGetControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * vMIB̎ThreadX^[g܂B
     *
     *
     * @param targetip m[hIPAhX
     * @param version SNMPo[W
     * @param community R~jeB
     * @param oid OID
     */
    public void setNodeAddStatistics(
        final String targetip, final int version, final String community,
        final String oid) {
        String ipAddressUnderbarConv =
            DBTableBase.IP + targetip.replace('.', '_');
        ipAddressUnderbarConv = ipAddressUnderbarConv.replace('-', '_');

        /* vWThreadX^[g */
        /* v̎OIDTheadN */
        Thread thread =
            new Thread(
                new ThreadStatisticsMibGet(
                    targetip, version, community, oid, 0, ipAddressUnderbarConv));
        thread.start();
    }

    /**
     * Ev̎f[^i[pɃf[^x[XɃe[u쐬܂B
     * Ev̎ThreadN܂B
     *
     * @param targetip m[hIPAhX
     * @param version SNMPo[W
     * @param community R~jeB
     * @param period ̎
     * @param oid OID
     * @param threshHold Ď臒l
     * @param type Ď^Cv
     */
    public void setStatistics(
        final String targetip, final int version, final String community,
        final String period, final String oid, final String threshHold,
        final String type) {
        logger.info("ThreadStatisticsMibGetControl OID = " + oid);

        String ipAddressUnderbarConv =
            DBTableBase.IP + targetip.replace('.', '_');
        ipAddressUnderbarConv = ipAddressUnderbarConv.replace('-', '_');

        // OIDMIB̎悵CX^X̗f[^x[X e[u쐬
        StatisticsMibDBRegister mibStatisGet =
            new StatisticsMibDBRegister(targetip, version, community);
        mibStatisGet.setDatabaseStatisMibInfomation(
            oid, period, threshHold, type);

        /* vWThreadX^[g */
        /* v̎OIDTheadN */
        Thread thread =
            new Thread(
                new ThreadStatisticsMibGet(
                    targetip, version, community, oid, 0, ipAddressUnderbarConv));
        thread.start();
    }

    /**
     * m[hҏWɂSnmp@Interface MIBWꍇThreadN܂B
     *
     * @param targetip m[hIPAhX
     * @param version SNMPo[W
     * @param community R~jeB
     * @param period ̎
     * @param oid OID
     */
    public void editNodeSnmpInfo(
        final String targetip, final int version, final String community,
        final String period, final String oid) {
        Thread t =
            new Thread(
                new ThreadNodeSnmpEdit(
                    targetip, version, community, period, oid));
        t.start();
    }

    /**
     * m[hҏWɂSNMPWꍇThreadNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private class ThreadNodeSnmpEdit implements Runnable {
        /* m[hIPAhX */
        private String targetip;

        /* SNMPo[W */
        private int version;

        /* R~jeB */
        private String community;

        /* ̎ */
        private String period;

        /* OID */
        private String oid;

        /**
         * SNMPvWꍇThreadNXCX^X𐶐܂B
         *
         * @param targetip m[hIPAhX
         * @param version SNMPo[W
         * @param community R~jeB
         * @param period ̎
         * @param oid OID
         */
        public ThreadNodeSnmpEdit(
            final String targetip, final int version, final String community,
            final String period, final String oid) {
            this.targetip = targetip;
            this.version = version;
            this.community = community;
            this.period = period;
            this.oid = oid;
        }

        /**
         * SNMPv̎悵܂B
         */
        public void run() {
            setStatistics(targetip, version, community, period, oid, "0", "");
        }
    }
}
