/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.top;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.nodemaneger.NodeManagerPerspective;
import netjfwatcher.engine.view.EngineManagerPerspective;
import netjfwatcher.snmpmanager.SnmpManagerPerspective;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

/**
 * Top ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TopView extends ViewPart {
	/* Display */
	private static Display display;

	/* White Color */
	private static Color whiteColor = new Color(null, 255, 255, 255);

	/* Black Color */
	private static Color blackColor = new Color(null, 0, 0, 0);

	/* GWStart{^ */
	private Button engineStartButton;
	/* SNMP Browser Start{^ */
	private Button snmpBrowserStartButton;

	
	protected static final int HORIZONTAL_SPAN1 = 1;
	
	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	/* Splash Image */
	private Image splashImage;

	/*
	 * GWɊւANVr_[
	 */
	private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();

	/**
	 * Top ViewNXCX^X𐶐܂B
	 * 
	 */
	public TopView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(final Composite parent) {
		/*
		 * ColorIuWFNgdisposeĂΐ
		 */
		if ((whiteColor == null) || whiteColor.isDisposed()) {
			whiteColor = new Color(null, 255, 255, 255);
		}

		if ((blackColor == null) || blackColor.isDisposed()) {
			blackColor = new Color(null, 0, 0, 0);
		}

		display = parent.getDisplay();

		/*
		 * x[XƂȂComposite𐶐Ac1Compositezu
		 */
		GridLayout gridLayout = new GridLayout(1, false);
		parent.setLayout(gridLayout);
		parent.setLayoutData(new GridData(GridData.FILL_BOTH));

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(gridLayout0);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH
				| GridData.HORIZONTAL_ALIGN_CENTER));
		composite.setBackground(whiteColor);
		composite.setForeground(blackColor);

		/* sComposite */
		Composite composite0 = new Composite(composite, SWT.NULL);
		composite0.setLayout(new GridLayout(1, false));
		composite0.setLayoutData(new GridData(GridData.FILL_BOTH
				| GridData.HORIZONTAL_ALIGN_CENTER));
		composite0.setBackground(whiteColor);
		composite0.setForeground(blackColor);
		

		/* Splash ImagezuComposite */
		Composite composite1 = new Composite(composite, SWT.NULL);
		composite1.setLayout(new GridLayout(HORIZONTAL_SPAN1, true));
		composite1.setLayoutData(new GridData(GridData.FILL_BOTH
				| GridData.HORIZONTAL_ALIGN_CENTER));
		composite1.setBackground(whiteColor);
		composite1.setForeground(blackColor);

		/* copyrigtCompositezu */
		Composite composite2 = new Composite(composite, SWT.NULL);
		composite2.setLayout(new GridLayout(1, true));
		composite2.setLayoutData(new GridData(GridData.FILL_BOTH
				| GridData.HORIZONTAL_ALIGN_CENTER));
		composite2.setBackground(whiteColor);
		composite2.setForeground(blackColor);

		/* GridData gridData0 = new GridData();

		Label label0 = new Label(composite0, SWT.NONE);
		label0.setBackground(whiteColor);
		label0.setText(" ");
		label0.setLayoutData(gridData0);
		*/

		createImage();

		Label label1 = new Label(composite1, SWT.CENTER);
		label1.setBackground(whiteColor);

		GridData gridData = new GridData(GridData.FILL_HORIZONTAL
				| GridData.VERTICAL_ALIGN_CENTER
				| GridData.HORIZONTAL_ALIGN_CENTER);
		
		gridData.horizontalSpan = HORIZONTAL_SPAN1;
		label1.setLayoutData(gridData);
		label1.setImage(splashImage);

		engineStartButton = new Button(composite1, SWT.NONE);
		gridData = new GridData(GridData.VERTICAL_ALIGN_CENTER
				| GridData.HORIZONTAL_ALIGN_CENTER);
		

		engineStartButton.setLayoutData(gridData);
		engineStartButton.setText("Network Watcher start");

		snmpBrowserStartButton = new Button(composite1, SWT.NONE);
		

		snmpBrowserStartButton.setLayoutData(gridData);
		snmpBrowserStartButton.setText("SNMP Browser start");
		

		
		/* Font(Display, String<Font>, int<TCY>, int<Font>); */
		Font font = new Font(Display.getCurrent(), "",
				TopViewPreference.TITLE_FONT_SIZE, SWT.BOLD | SWT.ITALIC);
		Label label = new Label(composite2, SWT.CENTER);
		label.setFont(font);
		label.setBackground(whiteColor);
		label.setText(" " + TopViewPreference.TOP_VIEW_TITLE + " ");

		GridData gridData2 = new GridData(GridData.FILL_BOTH
				| GridData.HORIZONTAL_ALIGN_CENTER);

		label.setLayoutData(gridData2);

		font = new Font(Display.getCurrent(), "",
				TopViewPreference.COPYRIGHT_FONT_SIZE, SWT.NORMAL | SWT.ITALIC);

		Label label3 = new Label(composite2, SWT.CENTER);
		label3.setFont(font);
		label3.setBackground(whiteColor);
		label3.setText(TopViewPreference.COPYRIGHT);

		GridData gridData3 = new GridData(GridData.FILL_BOTH
				| GridData.HORIZONTAL_ALIGN_CENTER);
		label3.setLayoutData(gridData3);

		setSelectionListener();
	}

	/*
	 * {^SelectionListenerZbg܂B
	 * 
	 */
	private void setSelectionListener() {
		engineStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				engineStartButton.setEnabled(false);

				actionBuilderEngine.getActionStartEngine().run();

				try {
					getSite()
							.getWorkbenchWindow()
							.getWorkbench()
							.showPerspective(
									EngineManagerPerspective.ID,
									getSite().getWorkbenchWindow());
					getSite()
							.getWorkbenchWindow()
							.getWorkbench()
							.showPerspective(
									NodeManagerPerspective.ID,
									getSite().getWorkbenchWindow());
				} catch (Exception e) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Abort system start.");
					logger.warning("Abort system start. " + e.getMessage());
				}
				engineStartButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		
		snmpBrowserStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				snmpBrowserStartButton.setEnabled(false);



				try {
					getSite()
							.getWorkbenchWindow()
							.getWorkbench()
							.openWorkbenchWindow(
									SnmpManagerPerspective.ID,
									getSite().getPage().getInput());

				} catch (Exception e) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Abort SNMP Browser start.");
					logger.warning("Abort SNMP Browser start. " + e.getMessage());
				}
				snmpBrowserStartButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/*
	 * Splash Image𐶐܂B
	 * 
	 */
	private void createImage() {
		URL url = null;

		try {
			url = bundle.getEntry(TopViewPreference.SPLASH_IMAGE_FILE);

			if (url == null) {
				/* Icon\[Xt@CȂꍇMO̎ */
				logger.severe("Not found icon file : "
						+ TopViewPreference.SPLASH_IMAGE_FILE);
			} else {
				splashImage = new Image(display, url.openStream());
			}
		} catch (IOException e) {
			logger.warning("Abort create image " + e.getMessage() + " for "
					+ TopViewPreference.SPLASH_IMAGE_FILE);
			e.printStackTrace();
		}
	}

	/**
	 * ImageyColorj܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (splashImage != null) {
			splashImage.dispose();
		}

		whiteColor.dispose();
		blackColor.dispose();
	}
}
