/*
 * Created on 2006/11/07
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.canvas;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;


public class CanvasViewConfigFileParse {

	private static final int CHART_VIEW_WIDTH = 1400;

	private static final int CHART_VIEW_HEIGHT = 800;
	
	/* ftHgXXP[ */
	private static final int X_POINT_VALUE0 = 1000;

	/* ftHgYXP[ */
	private static final int Y_POINT_VALUE0 = 450;

	protected static final int MAP_VIEW_WIDTH = 1900;

	protected static final int MAP_VIEW_HEIGHT = 1700;
	
	/* conf TAG */
	private static final String CONF_TAG = "conf";

	/* Chart TAG */
	private static final String CHART_TAG = "chart";

	/* Chart width TAG */
	private static final String CHART_WIDTH_TAG = "width";

	/* Chart height TAG */
	private static final String CHART_HEIGHT_TAG = "height";

	/* Chart X Scall TAG */
	private static final String CHART_X_SCALL_TAG = "x_scall";

	/* Chart Y Scall TAG */
	private static final String CHART_Y_SCALL_TAG = "y_scall";

	/* Node Map TAG */
	private static final String NODE_MAP_TAG = "node_map";

	/* Node Map width TAG */
	private static final String NODE_MAP_WIDTH_TAG = "width";

	/* Node Map height TAG */
	private static final String NODE_MAP_HEIGHT_TAG = "height";

	/* l */
	private static final String ATTRIBUTE_VALUE = "value";

	/* Logging */
	private static Logger logger = null;

	private int chartWidth = CHART_VIEW_WIDTH;

	private int chartHeight = CHART_VIEW_HEIGHT;

	private int chartXScall = X_POINT_VALUE0;

	private int chartYScall = Y_POINT_VALUE0;

	private int nodeMapWidth = MAP_VIEW_WIDTH;

	private int nodeMapHeight = MAP_VIEW_HEIGHT;

	public CanvasViewConfigFileParse() {
		logger = Logger.getLogger(this.getClass().getName());

		Document doc = null;

		/* bZ[W\[Xt@C */
		URL url = null;
		/* 摜肷邽߂PluginResource bundle */
		Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
		url = bundle.getEntry(FilePreference.CANVAS_DEFINE_FILE);

		if (url == null) {
			/* bZ[W\[Xt@CȂꍇMO̎ */
			logger.severe(url + " : Not Found");
		}

		try {
			SAXBuilder builder = new SAXBuilder();

			if (builder != null) {
				doc = builder.build(url.openStream());
			}
		} catch (JDOMException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		try {
			// rootvfo
			Element root = doc.getRootElement();

			Element chartEl = root.getChild(CHART_TAG);
			chartWidth = Integer.parseInt((chartEl.getChild(CHART_WIDTH_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
			chartHeight = Integer.parseInt((chartEl.getChild(CHART_HEIGHT_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
			chartXScall = Integer
					.parseInt((chartEl.getChild(CHART_X_SCALL_TAG))
							.getAttributeValue(ATTRIBUTE_VALUE));
			chartYScall = Integer
					.parseInt((chartEl.getChild(CHART_Y_SCALL_TAG))
							.getAttributeValue(ATTRIBUTE_VALUE));

			Element nodeMapEl = root.getChild(NODE_MAP_TAG);
			nodeMapWidth = Integer.parseInt((nodeMapEl
					.getChild(NODE_MAP_WIDTH_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
			nodeMapHeight = Integer.parseInt((nodeMapEl
					.getChild(NODE_MAP_HEIGHT_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	public int getChartHeight() {
		return chartHeight;
	}

	public int getChartWidth() {
		return chartWidth;
	}

	public int getNodeMapHeight() {
		return nodeMapHeight;
	}

	public int getNodeMapWidth() {
		return nodeMapWidth;
	}

	public int getChartXScall() {
		return chartXScall;
	}

	public int getChartYScall() {
		return chartYScall;
	}

}
