/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAlarmSocket;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAllAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAllAlarmSocket;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * Sm[hAlarm\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorAllNodeAlarm extends EditorNodeAlarm {
	/* MO */
	private static Logger logger;

	/** View^CgSuffix */
	public static final String TITLE_SUFFIX = " All Alarm View";

	/* A[e[uANZXɑSm[hIPAhX\R[h */
	private static final String ALARM_ALL = "all";


	/* AlarmɊւANV */
	private AlarmAction alarmAction = new AlarmAction();

	/* Display */
	private Display display;

	/* Alarme[uTimer */
	private AlarmTableTimerProcessor timerProcessor;

	/* `FbNJn{^ */
	private Button checkStartButton;

	/* `FbN~{^ */
	private Button checkStopButton;

	private boolean isRefresh = false;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorAllNodeAlarm() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();

		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		isSocket = nodeViewEditorInput.isSocket();
		isRefresh = nodeViewEditorInput.isRefresh();
		/* Alarm\Xge[u */
		AlarmTable alarmTable = new AlarmTable();
		table = alarmTable.createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		/* AlarmxImage */
		createImage(parent);

		/* ReLXgMenu */
		createContextMenu();

		/* Alarm\Xge[uZbg */
		setNodeAlarmeView(ALARM_ALL, sortColumn, sortDirection);

		/*
		 * TableōsNbNꂽꍇ̏
		 */
		table.addSelectionListener(new TableColumnControlTableListener(table,
				AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE));

		if (isRefresh) {
			alarmAction.refreshNodeAlarmTable();
		}
	}

	/**
	 * Alarm\Xge[u̕\XV܂B
	 * 
	 * @param ipAddress
	 *            m[hIPAhX
	 * @param sortColumn
	 *            e[u\[gJ
	 * @param sortDirection
	 *            \[g
	 */
	public void setNodeAlarmeView(String ipAddress, String sortColumn,
			String sortDirection) {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		/* Alarm擾 */
		ArrayList alarmInfoList = getAlarmList(ipAddress, sortColumn,
				sortDirection);

		if (alarmInfoList != null) {
			/* AlarmZbg */
			alarmCountText.setText(Integer.toString(alarmInfoList.size()));
		} else {
			return;
		}

		errorCount = 0;
		warningCount = 0;
		infoCount = 0;

		/* AlarmXg\e[uZbg */
		for (int i = 0; i < alarmInfoList.size(); i++) {
			String[] alarmCellArray = new String[AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS.length];

			AlarmInformation alarmInfo = (AlarmInformation) alarmInfoList
					.get(i);
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO] = alarmInfo
					.getAlarmID();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE] = alarmInfo
					.getAlarmDate();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME] = alarmInfo
					.getNodename();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP] = alarmInfo
					.getGroup();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS] = alarmInfo
					.getIpaddress();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE] = alarmInfo
					.getAlarmMessage();

			TableItem item = new TableItem(table, SWT.NONE);

			item.setText(alarmCellArray);
			item.setData(alarmCellArray);

			/* AlarmxAlarm\Foreground colorZbg */
			if (alarmInfo.getAlarmLevel().equals(AlarmViewFilter.ERROR_LEVEL)) {
				item.setForeground(TableListViewColor.getInstance()
						.getAlarmErrorLevelColor());
				item
						.setImage(
								AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
								errorImage);
				errorCount++;
			} else if (alarmInfo.getAlarmLevel().equals(
					AlarmViewFilter.WARNING_LEVEL)) {
				item.setForeground(TableListViewColor.getInstance()
						.getAlarmWarningLevelColor());
				item
						.setImage(
								AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
								warningImage);
				warningCount++;
			} else if (alarmInfo.getAlarmLevel().equals(
					AlarmViewFilter.INFO_LEVEL)) {
				item.setForeground(TableListViewColor.getInstance()
						.getAlarmInfoLevelColor());
				item
						.setImage(
								AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
								infoImage);
				infoCount++;
			} else {
				logger.warning("Unknown alarm level : "
						+ alarmInfo.getAlarmLevel());
			}
		}

		setStatusLine();
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[WZbg */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* SAlarm\j[Zbg */
		manager.add(alarmAction.getActionShowAllNodeAlarmListTable());

		/* Alarme[usIɂ̓A[mFj[Zbg */
		if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
			/* Alarme[usI */
			TableItem[] item = table.getSelection();

			String[] alarmTableInfo = (String[]) item[0].getData();

			if (!isSocket) {
				/* AlarmmFANVMenuɃZbg */
				((ActionConfirmAlarm) alarmAction.getActionConfirmAlarm())
						.setConfirmAlarm(
								alarmTableInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO],
								alarmTableInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
				manager.add(alarmAction.getActionConfirmAlarm());
			} else {
				/* AlarmmFANVMenuɃZbg */
				((ActionConfirmAlarmSocket) alarmAction
						.getActionConfirmAlarmSocket())
						.setConfirmAlarm(
								alarmTableInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO],
								alarmTableInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
				manager.add(alarmAction.getActionConfirmAlarmSocket());
			}
		}

		if (!isSocket) {
			/* SAlarmmFANVMenuɃZbg */
			((ActionConfirmAllAlarm) alarmAction.getActionConfirmAllAlarm())
					.setAlarmIPAddress(DBTableAlarm.ALL_NODE);
			manager.add(alarmAction.getActionConfirmAllAlarm());
		} else {
			/* SAlarmmFANVMenuɃZbg */
			((ActionConfirmAllAlarmSocket) alarmAction
					.getActionConfirmAllAlarmSocket())
					.setAlarmIPAddress(DBTableAlarm.ALL_NODE);
			manager.add(alarmAction.getActionConfirmAllAlarmSocket());
		}
	}

	/*
	 * Alarme[u\^C}[̐Ass܂B
	 * 
	 */
	private void startTimer() {
		if (!isSocket && (timerProcessor == null)) {
			/* Alarme[u\^C}[̐As */
			AlarmTableTimerProcessor.getInstance().setDisplay(display);
			AlarmTableTimerProcessor.getInstance().setAlarmCountText(
					alarmCountText);
			timerProcessor = AlarmTableTimerProcessor.getInstance();
			display.timerExec(AlarmTableTimerProcessor.TIMER, timerProcessor);
		} else if (!isSocket && (timerProcessor != null)) {
			display.timerExec(AlarmTableTimerProcessor.TIMER, timerProcessor);
		}
	}

	/*
	 * Alarme[u\^C}[~܂B
	 * 
	 */
	private void stopTimer() {
		if (timerProcessor != null) {
			/* Alarme[u\^C}[~ */
			display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
					timerProcessor);
		}
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (timerProcessor != null) {
			/* Alarme[u\^C}[~ */
			display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
					timerProcessor);
		}
	}

	/*
	 * Alarme[u𐶐NXłB e[uColumn\[g邽߂AbstractTableViewNX p܂B
	 * 
	 * @author Yoshimasa Matsumoto
	 * 
	 * @version 1.0
	 */
	private final class AlarmTable extends AbstractTableView {
		/* J0iNo.:Alarm IDj\[g */
		private boolean isCol0Direction = false;

		/* J1iAlarmoj\[g */
		private boolean isCol1Direction = true;

		/* J2iNodej\[g */
		private boolean isCol2Direction = true;

		/* J3iGroupj\[g */
		private boolean isCol3Direction = true;

		/* J4iIP Addressj\[g */
		private boolean isCol4Direction = true;

		/* J5iAlarm messagej\[g */
		private boolean isCol5Direction = true;

		/* e[uColumnImage܂Column(e[u\[gŎgp) */
		private int[] imageColumn = { AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE };

		/**
		 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
		 * 
		 * @param parent
		 *            Composite
		 */
		private Table createTable(Composite parent) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.numColumns = 1;
			parent.setLayout(gridLayout);

			/*  */
			Composite composite = new Composite(parent, SWT.NONE);
			composite.setLayout(new RowLayout(SWT.HORIZONTAL));

			GridData data = new GridData();
			data.horizontalAlignment = GridData.FILL;
			data.grabExcessHorizontalSpace = true;
			composite.setLayoutData(data);

			/* Alarm\Text */
			Label labelAddress = new Label(composite, SWT.NONE);
			labelAddress.setText("Alarm count");
			alarmCountText = new Text(composite, SWT.BORDER | SWT.RIGHT
					| SWT.READ_ONLY);
			alarmCountText.setLayoutData(new RowData(COUNT_TEXT_WIDTH, -1));

			alarmCountText.setEditable(false);
			alarmCountText.setEnabled(false);
			alarmCountText.setBackground(textBackColor);

			/* Alarme[uXV{^ */
			refreshButton = new Button(composite, SWT.NONE);
			refreshButton.setText("Refresh");

			if (!isSocket) {
				/* Alarm`FbN{^ */
				checkStartButton = new Button(composite, SWT.NONE);
				checkStartButton.setText("Auto check start");

				checkStopButton = new Button(composite, SWT.NONE);
				checkStopButton.setText("Auto check stop");
				checkStartButton.setEnabled(true);
				checkStopButton.setEnabled(false);
			}

			/* Alarme[u */
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			/*
			 * Alarme[uXV{^Xi[
			 */
			refreshButton.addSelectionListener(new SelectionListener() {
				public void widgetSelected(SelectionEvent event) {
					refreshButton.setEnabled(false);
					setNodeAlarmeView(ALARM_ALL, sortColumn, sortDirection);
					alarmCountText.setBackground(WHITE_COLOR);
					refreshButton.setEnabled(true);
				}

				public void widgetDefaultSelected(SelectionEvent event) {
				}
			});

			if (!isSocket) {
				checkStartButton.addSelectionListener(new SelectionListener() {
					public void widgetSelected(SelectionEvent event) {
						checkStartButton.setEnabled(false);

						startTimer();
						checkStopButton.setEnabled(true);
					}

					public void widgetDefaultSelected(SelectionEvent event) {
					}
				});
				checkStopButton.addSelectionListener(new SelectionListener() {
					public void widgetSelected(SelectionEvent event) {
						checkStopButton.setEnabled(false);

						if (timerProcessor != null) {
							/* Alarme[u\^C}[~ */
							stopTimer();
						}

						checkStartButton.setEnabled(true);
					}

					public void widgetDefaultSelected(SelectionEvent event) {
					}
				});
			}

			setTableColumn();

			return table;
		}

		private TableColumn col0;

		private TableColumn col1;

		private TableColumn col2;

		private TableColumn col3;

		private TableColumn col4;

		private TableColumn col5;

		/*
		 * e[uJZbg܂B
		 * 
		 */
		private void setTableColumn() {
			/*
			 * e[uColumn
			 */
			col0 = new TableColumn(table, SWT.CENTER);
			col0
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO]);
			col0.setWidth(computeCol0Width());

			col1 = new TableColumn(table, SWT.CENTER);
			col1
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE]);
			col1.setWidth(computeCol1Width());

			col2 = new TableColumn(table, SWT.CENTER);
			col2
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME]);
			col2.setWidth(computeCol2Width());

			col3 = new TableColumn(table, SWT.CENTER);
			col3
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP]);
			col3.setWidth(computeCol3Width());

			col4 = new TableColumn(table, SWT.CENTER);
			col4
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
			col4.setWidth(computeCol4Width());

			col5 = new TableColumn(table, SWT.CENTER);
			col5
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE]);
			col5.setWidth(computeCol5Width());

			/*
			 * e[uړꍇyтTCYꍇ̃Xi[
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
						}

						/**
						 * e[uTCYɃe[uJZbg܂B
						 */
						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			col0.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol0Direction = sortIntegerTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO,
							isCol0Direction, imageColumn);
				}
			});

			col1.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol1Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE,
							isCol1Direction, imageColumn);
				}
			});
			col2.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol2Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME,
							isCol2Direction, imageColumn);
				}
			});
			col3.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol3Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP,
							isCol3Direction, imageColumn);
				}
			});
			col4.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol4Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS,
							isCol4Direction, imageColumn);
				}
			});
			col5.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol5Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
							isCol5Direction, imageColumn);
				}
			});
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {
					col0.setWidth(computeCol0Width());
					col1.setWidth(computeCol1Width());
					col2.setWidth(computeCol2Width());
					col3.setWidth(computeCol3Width());
					col4.setWidth(computeCol4Width());
					col5.setWidth(computeCol5Width());

				}
			}
		}

		/*
		 * X[p[NX̃e[uColumn Clickɂ\[g\bh
		 * I[o[ChāAe[uRowForegroundABackground J[yImage\[gɂĂێ܂B
		 * 
		 * @see rctf.rssr.common.view.AbstractTableView#setTableItem
		 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets.
		 *      TableItem, java.lang.String[])
		 */
		public TableItem setTableItem(Table table, TableItem item, String[] strs) {
			Object obj = item.getForeground();
			Image image1 = item
					.getImage(AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE);

			item.dispose();
			item = new TableItem(table, SWT.NONE);

			item.setText(strs);
			item.setData(strs);
			item.setForeground((org.eclipse.swt.graphics.Color) obj);
			item.setImage(
					AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
					image1);

			return item;
		}
	}

	/**
	 * Alarme[uɊւANV`ANVNXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class AlarmAction extends ActionBuilderAlarmList {
		/*
		 * A[e[uɕ\f[^擾Ae[u XVX[p[NX̃\bhI[o[ChāA
		 * SẴm[h̃A[ɂăe[u\܂B
		 * 
		 * @see rctf.rssr.engine.view.model.ActionBuilderAlarmList
		 *      #refreshNodeAlarmTable()
		 */
		public void refreshNodeAlarmTable() {
			setNodeAlarmeView("all", sortColumn, sortDirection);
		}
	}
}
