/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.ping;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodePingChartView;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodePingChartViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable.ActionShowPingResponseData;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable.ActionShowPingResponseDataSocket;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingChart;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingTable;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;



/**
 * j[}l[W⃁j[Ƀm[hPingĎj[ǉ
 * \bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodePingMenu {
    /* MO */
    private static Logger logger;

    /* 摜肷邽߂PluginResource bundle */
    private Bundle bundle;

    /* Pingf[^Chart(Ot)`ANV Image */
    private Image chartImage;

    /* Pingf[^e[u\ANV Image */
    private Image tableImage;

    /* Pingf[^e[u\ANVr_[ */
    private ActionBuilderNodeDataTable dataTableAction =
        new ActionBuilderNodeDataTable();

    /* Pingf[^Chart(Ot)`ANVr_[ */
    private ActionBuilderChart nodeChart = new ActionBuilderChart();

    /**
     * m[hPingĎ֘Aj[𐶐NXCX^X𐶐܂B
     *
     */
    public NodePingMenu() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
    * wMenuManagerɃm[hPingj[ǉ܂B
    *
    * @param manager IMenuManager
    * @param targetNodeInfo m[hĎ
    * @param isSocket SocketoRŏ擾邩ۂtO
    */
    public void createPingMenu(
        IMenuManager manager, NodeInformation targetNodeInfo, boolean isSocket) {
        /* Menu}l[Wɐ */
        MenuManager optionMenu =
            new MenuManager(MenuPreference.NODE_PING_RESPONSE_DATA);
        manager.add(optionMenu);
        optionMenu.add(new Separator());

        String title =
            targetNodeInfo.getNodename() + "(" + targetNodeInfo.getIpaddress()
            + ") " + "Ping " + AbstractEditorNodeChart.TITLE_SUFFIX;
        ArrayList nameList = new ArrayList();
        nameList.add(
            targetNodeInfo.getNodename() + "(" + targetNodeInfo.getIpaddress()
            + ")");

        if (!isSocket) {
            /*
             * Pingf[^e[u\ANV
             */
            ActionShowPingResponseData pingDataTableAction =
                ((ActionShowPingResponseData) dataTableAction
                .actionShowPingDataView());
            pingDataTableAction.setNodeInfo(targetNodeInfo);
            optionMenu.add(pingDataTableAction);

            /*
             * Pingf[^Ot\ANV
             */
            ((ActionNodePingChartView) nodeChart.getActionNodePingChartView())
            .setTitle(title);
            ((ActionNodePingChartView) nodeChart.getActionNodePingChartView())
            .setNodeInfo(targetNodeInfo);

            ((ActionNodePingChartView) nodeChart.getActionNodePingChartView())
            .setNameList(nameList);
            optionMenu.add(nodeChart.getActionNodePingChartView());
        } else {
            /*
             * Pingf[^e[u\ANV
             */
            ActionShowPingResponseDataSocket pingDataTableAction =
                ((ActionShowPingResponseDataSocket) dataTableAction
                .actionShowPingDataViewSocket());
            pingDataTableAction.setNodeInfo(targetNodeInfo);
            optionMenu.add(pingDataTableAction);

            /*
             * Pingf[^Ot\ANV
             */
            ((ActionNodePingChartViewSocket) nodeChart
            .getActionNodePingChartViewSocket()).setTitle(title);
            ((ActionNodePingChartViewSocket) nodeChart
            .getActionNodePingChartViewSocket()).setNodeInfo(targetNodeInfo);

            ((ActionNodePingChartViewSocket) nodeChart
            .getActionNodePingChartViewSocket()).setNameList(nameList);
            optionMenu.add(nodeChart.getActionNodePingChartViewSocket());
        }
    }

    /**
     * wMenuɃm[hPingj[ǉ܂B
     * m[hMap ViewPopupj[Pingj[ǉ܂B
     *
     * @param popUpMenu Menu
     * @param targetNodeInfo m[hĎ
     * @param isSocket SocketoRŏ񂗂擾邩ۂtO
     */
    public void createPingMenu(
        Menu popUpMenu, NodeInformation targetNodeInfo, boolean isSocket) {
        MenuItem pingMenuItem = new MenuItem(popUpMenu, SWT.CASCADE);

        /* 摜肷邽߂PluginResource bundle */
        bundle = NetJFWatcherPlugin.getInstance().getBundle();

        ImageDescriptor chartImageDescriptor =
            ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.CHART_IMAGE_FILE));
        ImageDescriptor tableImageDescriptor =
            ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.TABLE_IMAGE_FILE));

        if (chartImage == null) {
            chartImage = chartImageDescriptor.createImage();
        }

        if (tableImage == null) {
            tableImage = tableImageDescriptor.createImage();
        }

        pingMenuItem.setText(MenuPreference.NODE_PING_RESPONSE_DATA);

        Menu pingSubmenu = new Menu(pingMenuItem);
        pingMenuItem.setMenu(pingSubmenu);

        /*
         * Pingf[^Ot\ANV
         */
        String title =
            targetNodeInfo.getNodename() + "(" + targetNodeInfo.getIpaddress()
            + ") " + "Ping ";

        MenuItem subMenuItemPingTable = new MenuItem(pingSubmenu, SWT.PUSH);
        subMenuItemPingTable.setText(title + " Table");
        subMenuItemPingTable.setImage(tableImage);

        // menuItem1_1.setImage(tableImage);
        NodeMapMenuNodePingTable nodePingTable =
            new NodeMapMenuNodePingTable(targetNodeInfo, isSocket);
        subMenuItemPingTable.addSelectionListener(nodePingTable);

        MenuItem subMenuItemPingChart = new MenuItem(pingSubmenu, SWT.PUSH);
        subMenuItemPingChart.setText(title + " Chart");
        subMenuItemPingChart.setImage(chartImage);

        ArrayList nameList = new ArrayList();
        nameList.add(
            targetNodeInfo.getNodename() + "(" + targetNodeInfo.getIpaddress()
            + ")");

        NodeMapMenuNodePingChart nodePingChart =
            new NodeMapMenuNodePingChart(targetNodeInfo, isSocket, nameList);
        subMenuItemPingChart.addSelectionListener(nodePingChart);
    }

    /**
     * Imagej܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (chartImage != null) {
            chartImage.dispose();
        }

        if (tableImage != null) {
            tableImage.dispose();
        }
    }
}
