/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.mibtree;

import java.util.logging.Logger;

import netjfwatcher.engine.filepreference.FilePreference;


/**
 * Agent MIB`CSVt@C͂AAgent OID Tree𐶐NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AgentMibTree extends AbstractMibTree {
    /* MO */
    private static Logger logger;

    /**
     * wMIB`t@CAgent OID Tree𐶐NX
     * CX^X𐶐܂B
     *
     * @param fileName MIB`t@C
     */
    private AgentMibTree(String fileName) {
        logger = Logger.getLogger(this.getClass().getName());
        this.parseCSVFile(fileName);
    }

    /**
     * MIB`t@C[h܂B
     *
     * @param fileName MIB`t@C
     */
    public void reloadOidTree(String fileName) {
        logger.info("Reload Agnet MIB define file : " + fileName);
        oidList.clear();
        oidHashMap.clear();
        mibDescripHashMap.clear();
        rootTreeNode = null;

        this.parseCSVFile(fileName);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AgentMibTree getInstance() {
        return SingletonResource.AGENT_OID_RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentMibTree AGENT_OID_RESOURCE =
            new AgentMibTree(FilePreference.AGENT_MIB_DEFINE_FILE);
    }
}
