/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import netjfwatcher.snmp.mibtree.MibInfo;



/**
 * SNMP AgentƂOIDCX^XێNXłB
 * OIDL[ƂOIDHashMapƂĕێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AgentInstanceDataMap {
    // OIDL[ƂăCX^XێMAp
    private Map agentInstanceMap = Collections.synchronizedMap(new HashMap());

    /**
     * SNMP AgentƂOIDCX^XێNX
     * CX^X𐶐܂B
     *
     */
    private AgentInstanceDataMap() {
    }

    /**
     * OIDKeyƂOIDo܂B
     *
     * @param oidKey OID
     * @return OID
     */
    public MibInfo getAgentInstanceDataInfo(String oidKey) {
        return (MibInfo) agentInstanceMap.get(oidKey);
    }

    /**
     * OIDKeyƂOIDi[܂B
     *
     * @param oidKey OID
     * @param oidInfo OID
     */
    public void setAgentInstanceDataMap(String oidKey, Object oidInfo) {
        agentInstanceMap.put(oidKey, oidInfo);
    }

    /**
     * SNMP AgentƂOIDCX^XێNX
     * CX^XԂ܂B
     *
     * @return NXCX^X
     */
    public static AgentInstanceDataMap getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * AgentCX^Xf[^MapԂ܂B
     *
     * @return agentInstanceMap AgentCX^Xf[^Map
     */
    public Map getAgentInstanceMap() {
        return agentInstanceMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentInstanceDataMap RESOURCE = new AgentInstanceDataMap();
    }
}
