/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.util.HashMap;
import java.util.Map;

import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;



/**
 * SNMP AgentłSysUp TimeǗNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AgentSysupTime {
    /*
     * SNMP AgentłSysUp TimeǗVOgNX
     * CX^X𐶐܂B
     */
    private AgentSysupTime() {
    }

    /**
     * Agent SysupTime(1.3.6.1.2.1.1.3.0)CX^XXV
     * ܂B
     *
     * @return agentSysUpTimeInstanceDataOidInfo SysUpTime OID
     */
    public MibInfo updateSysupTime() {
        AgentMibTree mibtable = AgentMibTree.getInstance();
        HashMap<String, MibInfo> agentOidHashMap = mibtable.getOidHashMap();
        MibInfo agentSysUpTimeInstanceDataOidInfo = null;

        if (agentOidHashMap.containsKey(AgentDataImport.SYSUPTIME_OID)) {
            agentSysUpTimeInstanceDataOidInfo =
                (MibInfo) agentOidHashMap.get(AgentDataImport.SYSUPTIME_OID);

            if (agentSysUpTimeInstanceDataOidInfo != null) {
                /*
                     * sysupTimef[^ZoAmsPʂ10msPʃf[^
                     * ϊSNMPIuWFNg
                     */
                long sysupTimeMills =
                    (System.currentTimeMillis()
                    - ThreadAgent.getInstance().getStartEngineTime()) / 10;
                AbstractSnmpObject sysupTimeObject =
                    new SnmpTimeTicks(sysupTimeMills);

                /* G[WFgf[^ێĂHashMap擾 */
                Map tableAgentMap =
                    AgentInstanceDataMap.getInstance().getAgentInstanceMap();
                MibInfo agentTableOidInfo =
                    (MibInfo) tableAgentMap.get(AgentDataImport.SYSUPTIME_OID);
                agentTableOidInfo.setValue(sysupTimeObject.toString());
                AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(
                    AgentDataImport.SYSUPTIME_OID, agentTableOidInfo);

                /*
                 * AgentCX^Xf[^XV
                 */
                agentSysUpTimeInstanceDataOidInfo.setAgentMibValue(sysupTimeObject);
                agentOidHashMap.put(
                    AgentDataImport.SYSUPTIME_OID, agentSysUpTimeInstanceDataOidInfo);
                mibtable.setOidHashMap(agentOidHashMap);
                mibtable = AgentMibTree.getInstance();
                agentOidHashMap = mibtable.getOidHashMap();
                agentSysUpTimeInstanceDataOidInfo =
                    (MibInfo) agentOidHashMap.get(
                        AgentDataImport.SYSUPTIME_OID);
            }
        }

        return agentSysUpTimeInstanceDataOidInfo;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static AgentSysupTime getInstance() {
        return SingletonResource.AGENT_SYSUPTIME_INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentSysupTime AGENT_SYSUPTIME_INSTANCE =
            new AgentSysupTime();
    }
}
