/*
 * Created on 2004/12/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.security.GeneralSecurityException;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.preference.SnmpV3Preference;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserAgentManager;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;



/**
 * SNMP}l[W̃G[WFgoiDiscoverjV[PX
 * 䂷邽߂̃\bhNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentV3DiscoverySequence {
    /* MO */
    private static Logger logger;

    /**
     * Snmp}l[W̃G[WFgoiDiscoverjV[PX
     * CX^X𐶐܂B
     *
     */
    public AgentV3DiscoverySequence() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Snmp}l[WDiscovery EngineIDɑ΂鉞bZ[W
     * 쐬ĕԂ܂B
     *
     * @param requestID ʎq
     * @param msgIDString SNMP V3 msgID
     * @return resSendSNMPSequence SNMP SequencebZ[W
     * @throws SnmpBadValueException SNMPbZ[Wňُ킪ꍇ
     */
    public SnmpSequence createDiscoverySnmpEngineIDMessage(
        final int requestID, final String msgIDString) throws SnmpBadValueException {
        int snmpVersion = SnmpPreference.SNMPV3;
        int securityModel = SnmpV3Preference.SECURITY_MODEL_USM;
        int msgID = Integer.parseInt(msgIDString);

        // \[Xt@CsnmpEngineIDǂݏo
        SnmpV3AgentConfigInfo snmpV3AgentConfigInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();
        String snmpV3AgentSnmpEngineID =
            snmpV3AgentConfigInfo.getSnmpEngineID();
        SnmpEngineID snmpEngineID = new SnmpEngineID(snmpV3AgentSnmpEngineID);
        int snmpEngineBoots = 0;

        String contextName = "";

        /* Discovery EngineIDɑ΂SNMP SequencebZ[W */
        SnmpSequence resSendSNMPSequence = new SnmpSequence();
        SnmpSequence msgSecurityParameters = null;

        try {
            // Header
            // msgVersion
            resSendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));

            // msgGlobalData
            SnmpSequence msgGlobalData = new SnmpSequence();

            // msgID
            msgGlobalData.addSNMPObject(new SnmpInteger(msgID));

            // msgMaxSize
            msgGlobalData.addSNMPObject(
                new SnmpInteger(SnmpV3Preference.SNMP_V3_MSG_MAXSIZE));

            // msgFlagsreport flagZbg
            byte msgFlag = (byte) SnmpV3Preference.SNMPV3_MSG_FLAGS_REPORT;

            msgGlobalData.addSNMPObject(
                new SnmpOctetString(new byte[] { msgFlag }));

            // msgSecurityModel
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            resSendSNMPSequence.addSNMPObject(msgGlobalData);

            // msgSecurityParameters
            msgSecurityParameters = new SnmpSequence();

            // msgAuthoritativeEngineID
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(snmpEngineID.getId()));

            // msgAuthoritativeBoots
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineBoots));

            // msgAuthoritativeEngineTime
            int snmpEngineTime = 0;

            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineTime));

            // msgUserName
            msgSecurityParameters.addSNMPObject(new SnmpOctetString());

            // msgAuthenticationParameters
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(new byte[0]));

            // msgPrivacyParameters
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(new byte[0]));

            resSendSNMPSequence.addSNMPObject(
                new SnmpOctetString(msgSecurityParameters.getBEREncoding()));

            // msgData
            SnmpSequence msgData = new SnmpSequence();

            // contextEngineID
            msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));

            // contextName
            msgData.addSNMPObject(new SnmpOctetString(contextName));

            // PDU Data
            SnmpPDU sendPDU = null;

            try {
                /* PDU */
                sendPDU = this.createDiscoverySnmpEngineIDReportPDU(requestID);
            } catch (SnmpBadValueException e) {
                logger.warning(
                    "Abort create response PDU for discovery EngineID");
                e.printStackTrace();
                throw e;
            }

            msgData.addSNMPObject(sendPDU);
            resSendSNMPSequence.addSNMPObject(msgData);
        } catch (SnmpBadValueException e1) {
            logger.warning(
                "Abort create response message for discovery EngineID");
            e1.printStackTrace();
            throw e1;
        }

        return resSendSNMPSequence;
    }

    /**
     * Snmp}l[WDiscovery EngineBootsyEngineTime
     * ΂鉞bZ[W쐬ĕԂ܂B
     *
     * @param requestID NGXgʎq
     * @param engineID EngineID
     * @param msgIDString msgID
     * @return resSendSNMPSequence SNMP SequencebZ[W
     * @throws GeneralSecurityException ZLeB֘Aňُ킪
     * ꍇ
     * @throws SnmpBadValueException f[^ňُ킪ꍇ
     */
    public SnmpSequence createDiscoveryBootsAndTimeMessage(
        final int requestID, final String engineID, final String msgIDString)
        throws GeneralSecurityException, SnmpBadValueException {
        logger.info("Discovery snmpEngineBoots and snmpEngineTime");

        int snmpVersion = SnmpPreference.SNMPV3;
        int securityModel = SnmpV3Preference.SECURITY_MODEL_USM;
        int msgID = Integer.parseInt(msgIDString);

        SnmpEngineID snmpEngineID = new SnmpEngineID(engineID);
        SnmpV3AgentConfigInfo snmpV3AgentConfigInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();
        String userName = snmpV3AgentConfigInfo.getUserName();
        int snmpEngineBoots = 0;
        snmpEngineBoots =
            Integer.parseInt(snmpV3AgentConfigInfo.getSnmpEngineBoots());

        long agentStartTime =
            (System.currentTimeMillis()
            - ThreadAgent.getInstance().getStartEngineTime()) / 1000;

        logger.info("Discovry snmpEngineID : " + engineID);
        logger.info("Discovry snmpEngineBoots : " + snmpEngineBoots);
        logger.info("Discovry agentStartTime : " + agentStartTime);

        /*
         * Discovery EngineBootsyEngineTimeɑ΂
         * SNMP SequencebZ[W
         */
        SnmpSequence resSendSNMPSequence = new SnmpSequence();
        SnmpSequence msgSecurityParameters = null;

        UsmUserEntry usmUserEntry = null;

        logger.info("usmUserEntry snmpEngineID : " + snmpEngineID);
        logger.info("usmUserEntry userName : " + userName);

        usmUserEntry =
            UsmUserAgentManager.getInstance().getUsmUserEntry(
                snmpEngineID, userName);

        if (usmUserEntry == null) {
            logger.warning("Not user entry");
            logger.warning("snmpEngineID : " + snmpEngineID);
            logger.warning("userName : " + userName);
        }

        try {
            // Header
            // msgVersion	
            resSendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));

            // msgGlobalData
            SnmpSequence msgGlobalData = new SnmpSequence();

            // msgID
            msgGlobalData.addSNMPObject(new SnmpInteger(msgID));

            // msgMaxSize
            msgGlobalData.addSNMPObject(
                new SnmpInteger(SnmpV3Preference.SNMP_V3_MSG_MAXSIZE));

            // msgFlags
            // msgFlagsreport flagZbg
            boolean authFlag = false;
            boolean privFlag = false;
            String authPriv = snmpV3AgentConfigInfo.getAuthPriv();
            logger.info("authPriv : " + authPriv);

            if (authPriv.equals(SnmpV3Preference.AUTH)) {
                authFlag = true;
                privFlag = false;
            } else if (authPriv.equals(SnmpV3Preference.PRIV)) {
                authFlag = true;
                privFlag = true;
            } else if (authPriv.equals(SnmpV3Preference.NOAUTH)) {
                authFlag = false;
                privFlag = false;
            }

            /*
             * msgFlagsreport flagZbg
             */
            byte msgFlag = (byte) SnmpV3Preference.SNMPV3_MSG_FLAGS_REPORT;

            if (authFlag) {
                // Authw莞ɂ́A|[gFlagZbgȂ
                msgFlag = (byte) SnmpV3Preference.SNMPV3_MSG_FLAGS_AUTH;
            }

            msgGlobalData.addSNMPObject(
                new SnmpOctetString(new byte[] { msgFlag }));

            // msgSecurityModel
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            resSendSNMPSequence.addSNMPObject(msgGlobalData);

            // msgSecurityParameters
            msgSecurityParameters = new SnmpSequence();

            // msgAuthoritativeEngineID
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(snmpEngineID.getId()));

            // msgAuthoritativeBoots
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineBoots));

            // msgAuthoritativeEngineTime
            int snmpEngineTime =
                (int) ((System.currentTimeMillis()
                - ThreadAgent.getInstance().getStartEngineTime()) / 1000);
            msgSecurityParameters.addSNMPObject(
                new SnmpInteger(snmpEngineTime));

            // msgUserName
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(userName));

            // msgAuthenticationParameters
            if (authFlag) {
                /* AUTHw莞msgAuthenticationParameters12Bytëm */
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(
                        new byte[SnmpV3Preference.MSG_AUTHENTICATION_PARAM_MSG_DIGEST_LEN]));
            } else {
                msgSecurityParameters.addSNMPObject(
                    new SnmpOctetString(new byte[0]));
            }

            // msgPrivacyPara
            msgSecurityParameters.addSNMPObject(
                new SnmpOctetString(new byte[0]));

            resSendSNMPSequence.addSNMPObject(
                new SnmpOctetString(msgSecurityParameters.getBEREncoding()));

            // msgData
            SnmpSequence msgData = new SnmpSequence();

            // contextEngineID
            msgData.addSNMPObject(new SnmpOctetString());

            // contextName
            msgData.addSNMPObject(new SnmpOctetString());

            // PDU Data
            SnmpPDU reportPDUDiscoveryEngineBootsAndTime = null;

            try {
                reportPDUDiscoveryEngineBootsAndTime =
                    this.creasteDiscoveryEngineBootsAndTimeReportPDU(requestID);
            } catch (SnmpBadValueException e) {
                logger.warning(
                    "Abort create response PDU"
                    + " for discovery EngineBoots/EngineTime");
                e.printStackTrace();
                throw e;
            }

            msgData.addSNMPObject(reportPDUDiscoveryEngineBootsAndTime);

            resSendSNMPSequence.addSNMPObject(msgData);

            // bZ[WF؃R[h(MAC)
            if (authFlag) {
                try {
                    SnmpOctetString msgAuthenticationParametersOctet = null;

                    msgAuthenticationParametersOctet =
                        UsmSecuritySubsystem.getInstance().setAuth(
                            resSendSNMPSequence, msgSecurityParameters,
                            usmUserEntry.getUsmUserAuthKey());

                    msgSecurityParameters.addSNMPObject(
                        msgAuthenticationParametersOctet,
                        SnmpV3Preference.SECURITY_PARAMS_MSG_AUTH_PARAMS);
                } catch (GeneralSecurityException e2) {
                    logger.warning(
                        "GeneralSecurityException at create response PDU "
                        + "for discovery EngineBoots/EngineTime");
                    e2.printStackTrace();
                    throw e2;
                }

                resSendSNMPSequence.addSNMPObject(
                    new SnmpOctetString(msgSecurityParameters.getBEREncoding()),
                    2);
            }
        } catch (SnmpBadValueException e1) {
            logger.warning(
                "Abort create response message"
                + " for discovery EngineBoots/EngineTime");
            e1.printStackTrace();
            throw e1;
        }

        return resSendSNMPSequence;
    }

    /**
     * Snmp}l[WDiscovery EngineIDɑ΂鉞PDU
     * 쐬ĕԂ܂B
     *
     * @param requestID ʎq
     * @return pdu Snmp}l[WDiscovery EngineID
     * ΂鉞PDU
     * @throws SnmpBadValueException PDU̐Ɏsꍇ
     */
    private SnmpPDU createDiscoverySnmpEngineIDReportPDU(final int requestID)
        throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;

        byte pduType = SnmpBERCodec.SNMP_MSG_REPORT;
        SnmpPDU pdu = null;

        // SNMP PDU
        try {
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.UNKNOWN_ENGINE_ID);
            SnmpSequence varList;

            AbstractSnmpObject newVar = new SnmpCounter32(3);

            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, newVar);
            varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            //@SNMP PDU
            pdu = new SnmpPDU(
                    pduType, requestID, errorStatus, errorIndex, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create Discovery SnmpEngineID reportPDU : "
                + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException(
                "Abort create Discovery SnmpEngineID reportPDU : "
                + e.getMessage());
        }

        return pdu;
    }

    /**
     * Snmp}l[WDiscovery EngineBootsyEngineTime
     * ɑ΂鉞PDU쐬ĕԂ܂B
     *
     * @param requestID ʎq
     * @return reportPdu Snmp}l[WDiscovery EngineBoots
     * yEngineTimeɑ΂鉞PDU
     * @throws SnmpBadValueException PDU̐Ɏsꍇ
     */
    private SnmpPDU creasteDiscoveryEngineBootsAndTimeReportPDU(
        final int requestID) throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;

        byte pduType = SnmpBERCodec.SNMP_MSG_REPORT;
        SnmpPDU reportPdu = null;

        // SNMP PDU
        try {
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.NOT_IN_TIME_PACKET);
            SnmpSequence varList;

            AbstractSnmpObject newVar = new SnmpCounter32(1);

            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, newVar);

            varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            //@SNMP PDU
            reportPdu =
                new SnmpPDU(
                    pduType, requestID, errorStatus, errorIndex, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create Discovery SnmpEngineBoots/Time reportPDU : "
                + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException(
                "Abort create Discovery SnmpEngineBoots/Time reportPDU : "
                + e.getMessage());
        }

        return reportPdu;
    }
}
