/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.model.action.EngineThreadList;
import netjfwatcher.snmpmanager.model.ActionBuilderTrapReceiveTable;
import netjfwatcher.snmpmanager.trap.ThreadTrapReceive;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * TrapM\e[uView\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TrapReceiveTableView extends AbstractTableView {
	/**
	 * TrapMXbhԂANeBȕꍇɃXe[^XC \郁bZ[W
	 */
	public static final String TRAP_ALIVE_MESSAGE = "Trap receive status is active";

	/**
	 * TrapMXbhԂ~̏ꍇɃXe[^XC \郁bZ[W
	 */
	public static final String TRAP_DEAD_MESSAGE = "Trap receive status is stop";

	/* TrapMf[^\^C}[ */
	private static final int TRAP_RECEIVE_TIMER = 1000;

	/* e[u\\[gɂJ0̃ftHg̃\[g */
	private static boolean isCol0Direction = false;

	/* e[u\\[gɂJ1̃ftHg̃\[g */
	private static boolean isCol1Direction = true;

	/* e[u\\[gɂJ2̃ftHg̃\[g */
	private static boolean isCol2Direction = true;

	/* e[u\\[gɂJ3̃ftHg̃\[g */
	private static boolean isCol3Direction = true;

	/* e[u\\[gɂJ4̃ftHg̃\[g */
	private static boolean isCol4Direction = true;

	/* e[u\\[gɂJ5̃ftHg̃\[g */
	private static boolean isCol5Direction = true;

	/* e[u\\[gɂJ6̃ftHg̃\[g */
	private static boolean isCol6Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	private TableColumn col5;

	private TableColumn col6;

	/* J */
	private static final float COLUMN0NO = 0.03f;

	private static final float COLUMN1VERSION = 0.1f;

	private static final float COLUMN2ENTERPRSE = 0.2f;

	private static final float COLUMN3ADDORESS = 0.1f;

	private static final float COLUMN4GENERIC = 0.1f;

	private static final float COLUMN5SPECIFIC = 0.05f;

	private static final float COLUMN6TIMESTAMP = 0.2f;

	/* TrapMe[u */
	private Table table;

	/* TrapMTableViewer */
	private TableViewer viewer;

	/* TrapMe[uTimer */
	private TrapTableTimerProcessor timerProcessor;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* TrapMe[uANVNXCX^X */
	private ActionBuilderTrapReceiveTable actionTrapReceiveTableBuilder;

	/* Display */
	private Display display;

	/**
	 * ANV\z܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderTrapReceiveTable getActionBuilder() {
		return actionTrapReceiveTableBuilder;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
		setStatusLine();
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();

		/* TrapMe[u𐶐 */
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new TrapTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new TrapTableViewLabelProvider());

		/* ANV\z */
		actionTrapReceiveTableBuilder = new ActionBuilderTrapReceiveTable(
				display, table, statusLineManager);

		/* ReLXgj[AZbg */
		createContextMenu();

		/* ANV̏ */
		initActions();

		startTimer();
	}

	/**
	 * J0iNo.j̕Ԃ܂B
	 * 
	 * @return J0iNo.j̕
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0NO);
	}

	/**
	 * J1iVersionj̕Ԃ܂B
	 * 
	 * @return J1iVersionj̕
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1VERSION);
	}

	/**
	 * J2iEnterprisej̕Ԃ܂B
	 * 
	 * @return J2iEnterprisej̕
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2ENTERPRSE);
	}

	/**
	 * J3iAgent addressj̕Ԃ܂B
	 * 
	 * @return J3iAgent addressj̕
	 */
	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3ADDORESS);
	}

	/**
	 * J4iGeneric-trapj̕Ԃ܂B
	 * 
	 * @return J4iGeneric-trapj̕
	 */
	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4GENERIC);
	}

	/**
	 * J5iSpecific-trapj̕Ԃ܂B
	 * 
	 * @return J5iSpecific-trapj̕
	 */
	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5SPECIFIC);
	}

	/**
	 * J6iTimestampj̕Ԃ܂B
	 * 
	 * @return J6iTimestampj̕
	 */
	private int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6TIMESTAMP);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	private void createTable(Composite parent) {
		setStatusLine();

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		/*
		 * e[uJ0(Trap No.)Zbg
		 */
		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.TRAP_NO]);
		col0.setWidth(computeCol0Width());

		/*
		 * e[uJ1(Snmp Ver.)Zbg
		 */
		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.SNMPVERSION]);
		col1.setWidth(computeCol1Width());

		/*
		 * e[uJ2(Enterprise OID)Zbg
		 */
		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.ENTERPRISE_OID]);
		col2.setWidth(computeCol1Width());

		/*
		 * e[uJ3(Agent Address)Zbg
		 */
		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.AGENT_ADDRESS]);
		col3.setWidth(computeCol1Width());

		/*
		 * e[uJ4(Generic Trap Code)Zbg
		 */
		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.GENERIC_TRAP_CODE]);
		col4.setWidth(computeCol1Width());

		/*
		 * e[uJ5(Specific Trap)Zbg
		 */
		col5 = new TableColumn(table, SWT.LEFT);
		col5
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.SPECIFIC_TRAP]);
		col5.setWidth(computeCol1Width());

		/*
		 * e[uJ6(Timestamp)Zbg
		 */
		col6 = new TableColumn(table, SWT.LEFT);
		col6
				.setText(TrapTableViewLabelProvider.COLUMNS[TrapTableViewLabelProvider.TIMESTAMP]);
		col6.setWidth(computeCol6Width());

		/**
		 * e[uړyуTCỸXi[
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.swt.events.
					 *      ControlListener#controlMoved(org.eclipse.swt.events.ControlEvent)
					 */
					public void controlMoved(ControlEvent event) {
					}

					/**
					 * e[uResizedŃJĐݒ肵܂B
					 */
					public void controlResized(ControlEvent event) {
						setResizedTableColumnWidth();
					}
				});

		/**
		 * J0(Trap No.)wb_[ClickXi[ƂāAe[u \\[g܂B
		 * 
		 */
		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table,
						TrapTableViewLabelProvider.TRAP_NO, isCol0Direction);
			}
		});

		/**
		 * J1(Snmp Ver.)wb_[ClickXi[ƂāAe[ u\\[g܂B
		 * 
		 */
		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol1Direction = sortTable(table,
						TrapTableViewLabelProvider.SNMPVERSION, isCol1Direction);
			}
		});

		/**
		 * J2(Enterprise OID)wb_[ClickXi[ƂāA e[u\\[g܂B
		 * 
		 */
		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol2Direction = sortTable(table,
						TrapTableViewLabelProvider.ENTERPRISE_OID,
						isCol2Direction);
			}
		});

		/**
		 * J3(Agent Address)wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol3Direction = sortTable(table,
						TrapTableViewLabelProvider.AGENT_ADDRESS,
						isCol3Direction);
			}
		});

		/**
		 * J4(Generic Trap Code)wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol4Direction = sortTable(table,
						TrapTableViewLabelProvider.GENERIC_TRAP_CODE,
						isCol4Direction);
			}
		});

		/**
		 * J5(Specific Trap)wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol5Direction = sortTable(table,
						TrapTableViewLabelProvider.SPECIFIC_TRAP,
						isCol5Direction);
			}
		});

		/**
		 * J6(Timestamp)wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col6.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol6Direction = sortTable(table,
						TrapTableViewLabelProvider.TIMESTAMP, isCol6Direction);
			}
		});
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());
				col5.setWidth(computeCol5Width());

			}
		}

	}

	/**
	 * TrapMe[ũj[o[𐶐܂B preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		manager.add(getActionBuilder().getActionStartTrap());
		manager.add(getActionBuilder().getActionStopTrap());
		manager.add(getActionBuilder().getActionResetTrapTable());
	}

	/**
	 * TrapMe[uContectj[𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* ReLXgj[̐AZbg */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * TrapMɊւANV̏s܂B
	 * 
	 */
	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		// TrapMX^[gANV
		toolBarManager.add(getActionBuilder().getActionRestartTrap());

		// TrapMXgbvANV
		toolBarManager.add(getActionBuilder().getActionStopTrap());

		// TrapMX^[gANV
		toolBarManager.add(getActionBuilder().getActionStartTrap());

		// TrapMe[uZbgANV
		toolBarManager.add(getActionBuilder().getActionResetTrapTable());
	}

	/*
	 * Xe[^XC\s܂B TrapMThread̓Ԃ\܂B
	 */
	private void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		/* TrapMXbhԂXe[^XCɕ\ */
		ThreadTrapReceive trapthread;
		trapthread = ThreadTrapReceive.getInstance();

		Thread trapThread = (Thread) EngineThreadList.getInstance().getThread(
				EngineThreadList.TRAP_RECEIVE_THREAD);

		if ((trapThread == null) || !trapThread.isAlive()) {
			/* Engine Trap Receive check */
			if (trapthread.checkThread()) {
				statusLineManager.setMessage(TRAP_ALIVE_MESSAGE);
			} else {
				statusLineManager.setMessage(TRAP_DEAD_MESSAGE);
			}
		} else {
			statusLineManager.setMessage("Engine " + TRAP_ALIVE_MESSAGE);
		}
	}

	/*
	 * TrapMf[^\^C}[̐Ass܂B
	 * 
	 */
	private void startTimer() {
		/* TrapMf[^\^C}[̐As */
		TrapTableTimerProcessor.getInstance().setDisplay(display);
		TrapTableTimerProcessor.getInstance().setTable(table);
		timerProcessor = TrapTableTimerProcessor.getInstance();
		display.timerExec(TRAP_RECEIVE_TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* TrapMf[^\^C}[~ */
		display.timerExec(ActionBuilderTrapReceiveTable.TIMER_STOP,
				timerProcessor);
	}
}
