/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.nodetree;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.HttpAccessException;



/**
 * Httpɂăm[hĎ擾郁\bhNXłB
 *
 * @author Yoshimasa matsumoto
 * @version 1.0
 */
public class NodeListImport {
    /* MO */
    private static Logger logger;

    /**
     * m[hĎ擾郁\bhNXCX^X
     * 𐶐܂B
     *
     */
    public NodeListImport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * vtFXɃZbgĂURLɂHttpT[oɐڑA
     * XML`̃m[hĎXgC|[g܂B
     * 擾XML͂āAm[hPʂNodeInformationNX
     * CX^XƂăXgɊi[ĕԂ܂B
     *
     * @return nodeList m[hĎ񃊃Xg
     * @throws HttpAccessException HTTPANZXňُ킪ꍇ
     * @throws HttpAccessPreferenceException HTTPANZXURLLq
     * vtFXLoadňُ킪ꍇ
     */
    public ArrayList importNodeList()
        throws HttpAccessException, HttpAccessPreferenceException {
        String nodeListImportUrl =
            HttpAccessPreference.getInstance().getNodeListImportUrl();

        if (nodeListImportUrl == null) {
            /*
             * HTTPANZXURLvtFXɒ`ĂȂ
             * ꍇ
             */
            throw new HttpAccessPreferenceException(
                "Node list import url null");
        }

        ArrayList nodeList = null;
        HttpURLConnection urlConnection = null;
        InputStream urlInStream = null;

        /*  */
        BufferedReader in = null;

        try {
            // URLNX̃CX^X𐶐
            URL accessURL = new URL(nodeListImportUrl);

            urlConnection = (HttpURLConnection) accessURL.openConnection();
            urlInStream = urlConnection.getInputStream();

            /*
            // URLڑŏo̓Zbg
            uc.setDoOutput(true);
            // uc.setRequestProperty("User-Agent", "NetWatch URLConnect Check");
            // uc.setRequestProperty("Accept-Language", "ja");
            OutputStream os = uc.getOutputStream();
            PrintStream ps = new PrintStream(os);
            ps.println();

            ps.close(); */
            System.out.println("Date : " + new Date(urlConnection.getDate()));
            System.out.println(
                "getContentLength : " + urlConnection.getContentLength());

            /* m[hĎC|[gE */
            NodeListXmlParse xmlParse = NodeListXmlParse.getInstance();
            nodeList = xmlParse.loadAndParseNodeList();
        } catch (UnknownHostException e) {
            logger.warning("UnknownHostException " + e.getMessage());
            e.printStackTrace();
            throw new HttpAccessException(
                HttpAccessPreference.getInstance().getUrl() + " : "
                + e.getMessage());
        } catch (MalformedURLException e) {
            logger.warning("MalformedURLException " + e.getMessage());
            e.printStackTrace();
            throw new HttpAccessException(
                HttpAccessPreference.getInstance().getUrl() + " : "
                + e.getMessage());
        } catch (FileNotFoundException e) {
            logger.warning("FileNotFoundException " + e.getMessage());
            e.printStackTrace();
            throw new HttpAccessException(
                HttpAccessPreference.getInstance().getUrl() + " : "
                + e.getMessage());
        } catch (ConnectException e) {
            logger.warning("ConnectException " + e.getMessage());
            e.printStackTrace();
            throw new HttpAccessException(
                HttpAccessPreference.getInstance().getUrl() + " : "
                + e.getMessage());
        } catch (IOException e) {
            logger.warning("IOException " + e.getMessage());
            e.printStackTrace();
            throw new HttpAccessException(
                HttpAccessPreference.getInstance().getUrl() + " : "
                + e.getMessage());
        } finally {
            if (urlInStream != null) {
                try {
                    urlInStream.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            urlConnection.disconnect();

            if (in != null) {
                // ̓Xg[
                try {
                    in.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }

        return nodeList;
    }
}
