/*
 * Created on 2004/10/20
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.view;

import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.webbrowser.menutree.IMenuNode;
import netjfwatcher.webbrowser.menutree.NetMenuTree;
import netjfwatcher.webbrowser.menutree.NetMenuTreeGroup;
import netjfwatcher.webbrowser.menutree.NetMenuTreeListener;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewContentProvider;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewLabelProvider;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewSorter;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Node;


/**
 * lbg[NĎj[View\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMenuView extends ViewPart {
    /* EditorsPartANVBuilder*/
    private static ActionBuilderEditorsPartClose actionBuilder =
        new ActionBuilderEditorsPartClose();

    /* TreeViewer */
    private static TreeViewer menuTreeViewer;

    /**
     * lbg[NĎj[View̃CX^X𐶐܂B
     *
     */
    public NodeMenuView() {
        // nothing
    }

    /**
     * ActionBuilderԂ܂B
     *
     * @return actionBuilder ActionBuilder
     */
    public ActionBuilderEditorsPartClose getActionBuilder() {
        return actionBuilder;
    }

    /**
     * tH[JXZbgꂽꍇ̏łB
     */
    public void setFocus() {
    }

    /**
     * TreeViewerԂ܂B
     *
     * @return menuTreeViewer TreeViewer
     */
    public TreeViewer getViewer() {
        return menuTreeViewer;
    }

    /**
     * r[ꂽƂɂ܂sꃁ\bhłB
     *
     * @param parent@Composite
     */
    public void createPartControl(Composite parent) {
        /* j[Tree */
        menuTreeViewer = new TreeViewer(parent);
        menuTreeViewer.setUseHashlookup(true);
        menuTreeViewer.setContentProvider(new NetMenuTreeViewContentProvider());
        menuTreeViewer.setLabelProvider(new NetMenuTreeViewLabelProvider());

        /* j[Tree\[^[Zbg */
        menuTreeViewer.setSorter(new NetMenuTreeViewSorter());

        /* Viewerɓ̓f[^ݒ  */
        menuTreeViewer.setInput(createInitialInput());
        menuTreeViewer.expandAll();

        /* j[Zbg */
        createContextMenu();

        /* ANVZbg */
        initActions();

        createNetworkMenuTree();

        /* Nodej[ View̃Xi[ݒ */
        setupNodeMenuViewListener();
    }

    /**
     * Nodej[View̃Xi[o^s܂B
     * Xi[Tree\j[Click̏łB
     *
     */
    private void setupNodeMenuViewListener() {
        /*
         * j[Tree ViewɃXi[o^
         * iTree\j[Click̏j
         */
        menuTreeViewer.addSelectionChangedListener(new NetMenuTreeListener());
    }

    /**
     * ViewerݒpIuWFNg𐶐ĕԂ܂B
     *
     *
     *  @return rootOfRoot Object
     */
    private Object createInitialInput() {
        NetMenuTreeGroup rootOfRoot = new RootOfRootMenuGroup();

        return rootOfRoot;
    }

    /**
     * ContextMenuZbg܂B
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        /*  */
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /*  */
        manager.add(getActionBuilder().actionCloseAllEditors());
    }

    /**
     * ContextMenu𐶐܂B
     *
     */
    private void createContextMenu() {
        /* j[}l[W */
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        menuManager.addMenuListener(
            new IMenuListener() {
                /**
                 * j[I
                 */
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        /* j[}l[WZbg */
        Menu menu = menuManager.createContextMenu(menuTreeViewer.getControl());
        menuTreeViewer.getControl().setMenu(menu);
        getSite().registerContextMenu(menuManager, menuTreeViewer);
    }

    /**
     * ANV̏s܂B
     *
     */
    private void initActions() {
        /*  */
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        // Editor Pats closeANV
        toolBarManager.add(getActionBuilder().actionCloseAllEditors());
    }

    /**
     * lbg[NĎj[𐶐܂B
     *
     */
    public void createNetworkMenuTree() {
        /* ViewerݒŐݒ肳ꂽViewer̓f[^擾  */
        IMenuNode menuNode = (IMenuNode) getViewer().getInput();
        NetMenuTreeGroup baseMenuGroup = menuNode.getParent();

        if (menuNode instanceof NetMenuTreeGroup) {
            baseMenuGroup = (NetMenuTreeGroup) menuNode;
        }

        try {
            /*
             * WebANZXvtFX烁j[ɑΉURL
             * Zbg
             */
            baseMenuGroup.addChild(
                new NetMenuTree(
                    "Node Map Manager",
                    HttpAccessPreference.getInstance().getNodeMapUrl()));
            baseMenuGroup.addChild(
                new NetMenuTree(
                    "Node List Manager",
                    HttpAccessPreference.getInstance().getNodeManagerUrl()));

            baseMenuGroup.addChild(
                new NetMenuTree(
                    "Auth Node List Manager",
                    HttpAccessPreference.getInstance().getAuthNodeManagerUrl()));
            baseMenuGroup.addChild(
                new NetMenuTree(
                    "Auth Maintenance Manager",
                    HttpAccessPreference.getInstance().getMaintenanceUrl()));
            menuTreeViewer.expandAll();
            menuTreeViewer.refresh();
            setStatusLine();
        } catch (HttpAccessPreferenceException e) {
            e.printStackTrace();
        }
    }

    /*
     * Xe[^XC\Zbg܂B
     */
    private void setStatusLine() throws HttpAccessPreferenceException {
        /* Xe[^XC\L */
        SubStatusLineManager statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        statusLineManager.setMessage(
            "Access URL = " + HttpAccessPreference.getInstance().getUrl());
    }

    /**
    * u{́vŏʃO[vBgetParentnullԂAr[ɂ
    * ȂỹO[vB
    */
    private static final class RootOfRootMenuGroup extends NetMenuTreeGroup {
        RootOfRootMenuGroup() {
            super("RootOfRoot");
        }

        /**
         * eO[vԂ܂B
         *
         * @return eO[v
         */
        public NetMenuTreeGroup getParent() {
            return null;
        }

        /**
         * qm[h폜܂B
         *
         * @param toRemove Node
         */
        public void removeChild(Node toRemove) {
            // ROOT O[vƍB
        }
    }
}
