/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.DateCache;
import org.mortbay.util.RolloverFileOutputStream;
import org.mortbay.util.StringUtil;

public class NCSARequestLog
extends AbstractLifeCycle
implements RequestLog {
    private String _filename;
    private boolean _extended = true;
    private boolean _append = true;
    private int _retainDays = 31;
    private boolean _closeOut;
    private boolean _preferProxiedForAddress;
    private String _logDateFormat = "dd/MM/yyyy:HH:mm:ss ZZZ";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = TimeZone.getDefault().getID();
    private String[] _ignorePaths;
    private boolean _logLatency = false;
    private boolean _logCookies = false;
    private transient OutputStream _out;
    private transient OutputStream _fileOut;
    private transient DateCache _logDateCache;
    private transient PathMap _ignorePathMap;
    private transient Writer _writer;

    public NCSARequestLog() {
    }

    public NCSARequestLog(String filename) {
        this.setFilename(filename);
    }

    public void setFilename(String filename) {
        if (filename != null && (filename = filename.trim()).length() == 0) {
            filename = null;
        }
        this._filename = filename;
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._fileOut instanceof RolloverFileOutputStream) {
            return ((RolloverFileOutputStream)this._fileOut).getDatedFilename();
        }
        return null;
    }

    public void setLogDateFormat(String format) {
        this._logDateFormat = format;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogTimeZone(String tz) {
        this._logTimeZone = tz;
    }

    public String getLogTimeZone() {
        return this._logTimeZone;
    }

    public void setRetainDays(int retainDays) {
        this._retainDays = retainDays;
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    public void setExtended(boolean extended) {
        this._extended = extended;
    }

    public boolean isExtended() {
        return this._extended;
    }

    public void setAppend(boolean append) {
        this._append = append;
    }

    public boolean isAppend() {
        return this._append;
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this._ignorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    public void setLogCookies(boolean logCookies) {
        this._logCookies = logCookies;
    }

    public boolean getLogCookies() {
        return this._logCookies;
    }

    public void setLogLatency(boolean logLatency) {
        this._logLatency = logLatency;
    }

    public boolean getLogLatency() {
        return this._logLatency;
    }

    public void setPreferProxiedForAddress(boolean preferProxiedForAddress) {
        this._preferProxiedForAddress = preferProxiedForAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getRequestURI()) != null) {
                return;
            }
            if (this._fileOut == null) {
                return;
            }
            StringBuffer buf = new StringBuffer(160);
            String addr = null;
            if (this._preferProxiedForAddress) {
                addr = request.getHeader("X-Forwarded-For");
            }
            if (addr == null) {
                addr = request.getRemoteAddr();
            }
            buf.append(addr);
            buf.append(" - ");
            String user = request.getRemoteUser();
            buf.append(user == null ? " - " : user);
            buf.append(" [");
            buf.append(this._logDateCache.format(request.getTimeStamp()));
            buf.append("] \"");
            buf.append(request.getMethod());
            buf.append(' ');
            buf.append(request.getUri());
            buf.append(' ');
            buf.append(request.getProtocol());
            buf.append("\" ");
            int status = response.getStatus();
            if (status <= 0) {
                status = 404;
            }
            buf.append((char)(48 + status / 100 % 10));
            buf.append((char)(48 + status / 10 % 10));
            buf.append((char)(48 + status % 10));
            long responseLength = response.getContentCount();
            if (responseLength >= 0L) {
                buf.append(' ');
                if (responseLength > 99999L) {
                    buf.append(Long.toString(responseLength));
                } else {
                    if (responseLength > 9999L) {
                        buf.append((char)(48L + responseLength / 10000L % 10L));
                    }
                    if (responseLength > 999L) {
                        buf.append((char)(48L + responseLength / 1000L % 10L));
                    }
                    if (responseLength > 99L) {
                        buf.append((char)(48L + responseLength / 100L % 10L));
                    }
                    if (responseLength > 9L) {
                        buf.append((char)(48L + responseLength / 10L % 10L));
                    }
                    buf.append((char)(48L + responseLength % 10L));
                }
                buf.append(' ');
            } else {
                buf.append(" - ");
            }
            String log = buf.toString();
            Writer writer = this._writer;
            synchronized (writer) {
                this._writer.write(log);
                if (this._extended) {
                    this.logExtended(request, response, this._writer);
                    if (!this._logCookies) {
                        this._writer.write(" -");
                    }
                }
                if (this._logCookies) {
                    Cookie[] cookies = request.getCookies();
                    if (cookies == null || cookies.length == 0) {
                        this._writer.write(" -");
                    } else {
                        this._writer.write(" \"");
                        for (int i = 0; i < cookies.length; ++i) {
                            if (i != 0) {
                                this._writer.write(59);
                            }
                            this._writer.write(cookies[i].getName());
                            this._writer.write(61);
                            this._writer.write(cookies[i].getValue());
                        }
                        this._writer.write("\"");
                    }
                }
                if (this._logLatency) {
                    this._writer.write(" " + (System.currentTimeMillis() - request.getTimeStamp()));
                }
                this._writer.write(StringUtil.__LINE_SEPARATOR);
                this._writer.flush();
            }
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
        }
    }

    protected void logExtended(Request request, Response response, Writer writer) throws IOException {
        String referer = request.getHeader("Referer");
        if (referer == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(referer);
            writer.write("\" ");
        }
        String agent = request.getHeader("User-Agent");
        if (agent == null) {
            writer.write("\"-\" ");
        } else {
            writer.write(34);
            writer.write(agent);
            writer.write(34);
        }
    }

    protected void doStart() throws Exception {
        this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
        this._logDateCache.setTimeZoneID(this._logTimeZone);
        if (this._filename != null) {
            this._fileOut = new RolloverFileOutputStream(this._filename, this._append, this._retainDays);
            this._closeOut = true;
        } else {
            this._fileOut = System.err;
        }
        this._out = this._fileOut;
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMap();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        this._writer = new OutputStreamWriter(this._out);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            if (this._writer != null) {
                this._writer.flush();
            }
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
        if (this._out != null && this._closeOut) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                Log.ignore((Throwable)e);
            }
        }
        this._out = null;
        this._fileOut = null;
        this._closeOut = false;
        this._logDateCache = null;
        this._writer = null;
    }
}

